/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.metadata;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.LoggingUncaughtExceptionHandler;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.threading.ThreadPoolFactory;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import com.dd.plist.NSDictionary;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadedMetadataService
implements MetadataService<NSDictionary> {
    private static final Logger log = LogManager.getLogger((String)ThreadedMetadataService.class.getName());
    private static final int CACHE_LIMIT = PreferencesFactory.get().getInteger("fs.sync.metadata.cache.size");
    private final MetadataService<NSDictionary> proxy;
    private final ThreadPool pool;
    private final CompletionService<Boolean> completion;
    private final LinkedBlockingQueue<Future<Boolean>> queue = new LinkedBlockingQueue();
    private final AtomicLong counter = new AtomicLong();
    private final ReentrantLock lock = new ReentrantLock(true);

    public ThreadedMetadataService(MetadataService<NSDictionary> proxy) {
        this(proxy, CACHE_LIMIT);
    }

    public ThreadedMetadataService(MetadataService<NSDictionary> proxy, int capacity) {
        this.proxy = proxy;
        this.pool = ThreadPoolFactory.get((String)"metadata", (int)1, (ThreadPool.Priority)ThreadPool.Priority.norm, new LinkedBlockingQueue(capacity), (Thread.UncaughtExceptionHandler)new LoggingUncaughtExceptionHandler());
        this.completion = new ExecutorCompletionService<Boolean>(this.pool.executor(), this.queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(Local file) {
        this.lock.lock();
        try {
            while (this.counter.get() > 0L) {
                if (log.isInfoEnabled()) {
                    log.info(String.format("Await completion for %d submitted tasks", this.counter.get()));
                }
                try {
                    Uninterruptibles.getUninterruptibly(this.completion.take());
                }
                catch (InterruptedException | ExecutionException e) {
                    log.warn(String.format("Unhandled failure %s", e));
                }
                finally {
                    this.counter.decrementAndGet();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Future<Boolean> write(final Local file, final MetadataStorage.Key key, final NSDictionary dictionary) {
        this.counter.incrementAndGet();
        return this.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ThreadedMetadataService.this.proxy.write(file, key, dictionary).get();
            }
        });
    }

    @Override
    public NSDictionary read(Local file, MetadataStorage.Key key) {
        return this.proxy.read(file, key);
    }

    @Override
    public Future<Boolean> delete(final Local file, final MetadataStorage.Key key) {
        this.counter.incrementAndGet();
        return this.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ThreadedMetadataService.this.proxy.delete(file, key).get();
            }
        });
    }

    private Future<Boolean> submit(Callable<Boolean> callable) {
        Future<Boolean> submit = this.completion.submit(callable);
        this.cleanup();
        return submit;
    }

    private void cleanup() {
        if (this.queue.size() > CACHE_LIMIT) {
            this.lock.lock();
            try {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Cleanup completion queue with size %d", this.queue.size()));
                }
                while (this.completion.poll() != null) {
                    this.counter.decrementAndGet();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void close() {
        this.pool.shutdown(true);
    }
}

