/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.metadata;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.serializer.LocalDictionary;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import com.dd.plist.NSDictionary;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RenameResolvingMetadataService<T>
implements MetadataService<T> {
    private static final Logger log = LogManager.getLogger((String)RenameResolvingMetadataService.class.getName());
    private final MetadataService<T> proxy;

    public RenameResolvingMetadataService(MetadataService<T> proxy) {
        this.proxy = proxy;
    }

    @Override
    public NSDictionary read(Local file, MetadataStorage.Key key) {
        switch (key) {
            case rename: {
                return this.rename(this.proxy.read(file, key), file);
            }
        }
        return this.proxy.read(file, key);
    }

    private NSDictionary rename(NSDictionary dict, Local local) {
        if (null == dict) {
            return dict;
        }
        Local renamed = new LocalDictionary().deserialize((Object)dict.objectForKey("Local"));
        log.warn(String.format("Found rename flag in metadata for %s with target %s", local, renamed));
        NSDictionary recursive = this.proxy.read(renamed, MetadataStorage.Key.rename);
        if (null == recursive) {
            return dict;
        }
        if (recursive.equals((Object)dict)) {
            return dict;
        }
        return this.rename(recursive, renamed);
    }

    @Override
    public Future<Boolean> delete(Local file, MetadataStorage.Key key) {
        return this.proxy.delete(file, key);
    }

    @Override
    public MetadataService<T> open(Local directory) {
        this.proxy.open(directory);
        return this;
    }

    @Override
    public void flush(Local file) {
        this.proxy.flush(file);
    }

    @Override
    public Future<Boolean> write(Local file, MetadataStorage.Key key, NSDictionary dictionary) {
        return this.proxy.write(file, key, dictionary);
    }

    @Override
    public void purge(Local file) {
        this.proxy.purge(file);
    }

    @Override
    public void close() {
        this.proxy.close();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RenameResolvingMetadataService{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

