/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.metadata;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.SerializerFactory;
import ch.cyberduck.core.serializer.PathAttributesDictionary;
import ch.cyberduck.core.serializer.PathDictionary;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecursivePathSerializer {
    private static final Logger log = LogManager.getLogger((String)RecursivePathSerializer.class.getName());

    public NSDictionary serialize(Path file) {
        NSDictionary dict = new NSDictionary();
        dict.put("Type", (Object)String.valueOf(file.getType()));
        if (!file.isRoot()) {
            dict.put("Parent", (NSObject)this.serialize(file.getParent()));
        }
        dict.put("Name", (Object)file.getName());
        dict.put("Remote", (Object)file.getAbsolute());
        if (file.getSymlinkTarget() != null) {
            dict.put("Symbolic Link", (NSObject)this.serialize(file.getSymlinkTarget()));
        }
        dict.put("Attributes", (NSObject)file.attributes().serialize(SerializerFactory.get()));
        return dict;
    }

    public <T> Path deserialize(NSDictionary dict) {
        Path path;
        EnumSet<AbstractPath.Type> type = EnumSet.noneOf(AbstractPath.Type.class);
        if (!dict.containsKey("Type")) {
            log.error(String.format("Missing type in dictionary %s", dict));
            return null;
        }
        String typeObj = dict.objectForKey("Type").toString();
        for (String t : StringUtils.splitByWholeSeparator((String)StringUtils.replaceEach((String)typeObj, (String[])new String[]{"[", "]"}, (String[])new String[]{"", ""}), (String)", ")) {
            type.add(AbstractPath.Type.valueOf((String)t));
        }
        if (type.isEmpty()) {
            log.error(String.format("Empty type in dictionary %s", dict));
            return null;
        }
        if (!dict.containsKey("Attributes")) {
            log.error(String.format("Missing attributes in dictionary %s", dict));
            return null;
        }
        PathAttributes attributes = new PathAttributesDictionary().deserialize((Object)dict.objectForKey("Attributes"));
        if (dict.containsKey("Name")) {
            String name = dict.objectForKey("Name").toString();
            if (null == name) {
                log.error(String.format("Missing name in dictionary %s", dict));
                return null;
            }
            if (dict.containsKey("Parent")) {
                Path parent = this.deserialize((NSDictionary)dict.objectForKey("Parent"));
                path = new Path(parent, name, type, attributes);
            } else {
                path = new Path(name, type, attributes);
            }
        } else {
            if (!dict.containsKey("Remote")) {
                log.error(String.format("Missing remote in dictionary %s", dict));
                return null;
            }
            path = new Path(dict.objectForKey("Remote").toString(), type, attributes);
        }
        NSObject symlinkObj = dict.objectForKey("Symbolic Link");
        if (symlinkObj != null) {
            path.setSymlinkTarget(new PathDictionary().deserialize((Object)symlinkObj));
        }
        return path;
    }
}

