/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.metadata;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.exception.NotfoundException;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExtendedAttributesMetadataStorage
implements MetadataStorage {
    private static final Logger log = LogManager.getLogger((String)ExtendedAttributesMetadataStorage.class.getName());
    private static final XAttr xattr = (XAttr)Native.load(XAttr.class);

    @Override
    public void set(Local file, MetadataStorage.Key key, ByteBuffer value) throws IOException {
        String type = key.toString();
        this.set(file, type, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Local file, String type, ByteBuffer value) throws IOException {
        if (!file.exists()) {
            throw new IOException((Throwable)new NotfoundException(file.getAbsolute()));
        }
        Local local = file;
        synchronized (local) {
            Memory valueBuffer = new Memory((long)value.array().length);
            valueBuffer.write(0L, value.array(), 0, value.array().length);
            xattr.setxattr(file.getAbsolute(), type, (Pointer)valueBuffer, valueBuffer.size(), 0, 1);
        }
    }

    @Override
    public ByteBuffer get(Local file, MetadataStorage.Key key) throws IOException {
        String type = key.toString();
        return this.get(file, type);
    }

    public ByteBuffer get(Local file, String type) throws IOException {
        Local local = file;
        synchronized (local) {
            long bufferLength = xattr.getxattr(file.getAbsolute(), type, null, 0L, 0, 1);
            if (bufferLength < 0L) {
                return null;
            }
            Memory valueBuffer = new Memory(bufferLength);
            long valueLength = xattr.getxattr(file.getAbsolute(), type, (Pointer)valueBuffer, bufferLength, 0, 1);
            if (valueLength < 0L) {
                return null;
            }
            try {
                return ByteBuffer.wrap(valueBuffer.getByteArray(0L, Math.toIntExact(valueLength)));
            }
            catch (ArithmeticException e) {
                log.warn(String.format("Overflow reading extended attributes of %s for key %s", file, type));
                throw new IOException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Local file, MetadataStorage.Key key) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Remove xattr %s for file %s", new Object[]{key, file}));
        }
        Local local = file;
        synchronized (local) {
            xattr.removexattr(file.getAbsolute(), key.toString(), 1);
        }
    }

    @Override
    public void close() {
    }

    static interface XAttr
    extends Library {
        public static final int XATTR_NOFOLLOW = 1;
        public static final int XATTR_CREATE = 2;
        public static final int XATTR_REPLACE = 4;
        public static final int XATTR_NOSECURITY = 8;
        public static final int XATTR_NODEFAULT = 16;
        public static final int XATTR_SHOWCOMPRESSION = 32;
        public static final int XATTR_MAXNAMELEN = 127;
        public static final String XATTR_FINDERINFO_NAME = "com.apple.FinderInfo";
        public static final String XATTR_RESOURCEFORK_NAME = "com.apple.ResourceFork";

        public long getxattr(String var1, String var2, Pointer var3, long var4, int var6, int var7);

        public int setxattr(String var1, String var2, Pointer var3, long var4, int var6, int var7);

        public int removexattr(String var1, String var2, int var3);

        public long listxattr(String var1, Pointer var2, long var3, int var5);
    }
}

