/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.metadata;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ErrorListMetadataService<T>
implements MetadataService<T> {
    private static final Logger log = LogManager.getLogger((String)ErrorListMetadataService.class.getName());
    private Local directory;
    private final MetadataService<T> proxy;

    public ErrorListMetadataService(MetadataService<T> proxy) {
        this.proxy = proxy;
    }

    @Override
    public MetadataService<T> open(Local directory) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Open with directory %s", directory));
        }
        if (directory.exists()) {
            NSDictionary errors = this.copy(directory, MetadataStorage.Key.errors);
            for (String key : errors.allKeys()) {
                if (LocalFactory.get((String)key).exists()) continue;
                log.warn(String.format("Remove errors %s for file %s", errors.get((Object)key), key));
                errors.remove(key);
            }
            this.proxy.write(directory, MetadataStorage.Key.errors, errors);
        }
        this.proxy.open(directory);
        this.directory = directory;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Boolean> write(Local file, MetadataStorage.Key key, NSDictionary dictionary) {
        Future<Boolean> result = this.proxy.write(file, key, dictionary);
        switch (key) {
            case error: {
                try {
                    if (result.get().booleanValue()) {
                        MetadataService<T> metadataService = this.proxy;
                        synchronized (metadataService) {
                            NSDictionary errors = this.copy(this.directory, MetadataStorage.Key.errors);
                            if (log.isDebugEnabled()) {
                                log.debug(String.format("Write error for %s to list", file));
                            }
                            errors.put(file.getAbsolute(), (NSObject)dictionary);
                            return this.proxy.write(this.directory, MetadataStorage.Key.errors, errors);
                        }
                    }
                    break;
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    @Override
    public NSDictionary read(Local file, MetadataStorage.Key key) {
        NSDictionary dict = this.proxy.read(file, key);
        switch (key) {
            case errors: {
                if (null != dict) break;
                return new NSDictionary();
            }
        }
        return dict;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Boolean> delete(Local file, MetadataStorage.Key key) {
        switch (key) {
            case error: {
                MetadataService<T> metadataService = this.proxy;
                synchronized (metadataService) {
                    NSDictionary errors = this.copy(this.directory, MetadataStorage.Key.errors);
                    if (null != errors.remove(file.getAbsolute())) {
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Deleted error for %s from list", file));
                        }
                        this.proxy.write(this.directory, MetadataStorage.Key.errors, errors);
                    }
                    break;
                }
            }
        }
        return this.proxy.delete(file, key);
    }

    @Override
    public void flush(Local file) {
        this.proxy.flush(file);
    }

    @Override
    public void purge(Local file) {
        this.proxy.purge(file);
    }

    @Override
    public void close() {
        this.proxy.close();
    }

    protected NSDictionary copy(Local file, MetadataStorage.Key key) {
        NSDictionary current = this.read(file, key);
        NSDictionary copy = new NSDictionary();
        copy.putAll((Map)current.getHashMap());
        return copy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ErrorListMetadataService{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

