/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.metadata;

import ch.cyberduck.core.SerializerFactory;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.serializer.LocalDictionary;
import ch.cyberduck.core.serializer.PathAttributesDictionary;
import ch.iterate.mountainduck.sync.metadata.RecursivePathSerializer;
import ch.iterate.mountainduck.sync.metadata.SerializableOperationSerializer;
import ch.iterate.mountainduck.sync.queue.Operation;
import ch.iterate.mountainduck.sync.queue.SerializableOperation;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;

public class DefaultOperationSerializer
implements SerializableOperationSerializer {
    @Override
    public NSDictionary serialize(SerializableOperation operation) {
        NSDictionary dict = new NSDictionary();
        dict.put("Operation", (Object)operation.getOperation().name());
        dict.put("Local", (NSObject)operation.getLocal().serialize(SerializerFactory.get()));
        dict.put("Remote", (NSObject)new RecursivePathSerializer().serialize(operation.getRemote()));
        if (operation.getArg() != null) {
            dict.put("Argument", (NSObject)operation.getArg().serialize(SerializerFactory.get()));
        }
        if (operation.getArg() != null) {
            dict.put("Local Argument", (NSObject)operation.getLocalArg().serialize(SerializerFactory.get()));
        }
        if (operation.getAttr() != null) {
            dict.put("Attributes", (NSObject)operation.getAttr().serialize(SerializerFactory.get()));
        }
        if (operation.getLength() != -1L) {
            dict.put("Length", (Object)operation.getLength());
        }
        if (operation.getChecksum() != Checksum.NONE) {
            dict.put("Checksum", (Object)operation.getChecksum().hash);
        }
        if (operation.getApplication() != Application.notfound) {
            dict.put("Application", (Object)operation.getApplication().getIdentifier());
        }
        return dict;
    }

    @Override
    public SerializableOperation deserialize(NSDictionary dict) {
        SerializableOperation op = new SerializableOperation(Operation.valueOf(dict.objectForKey("Operation").toString()), new LocalDictionary().deserialize((Object)dict.objectForKey("Local")), dict.containsKey("Local Argument") ? new LocalDictionary().deserialize((Object)dict.objectForKey("Local Argument")) : null, new RecursivePathSerializer().deserialize((NSDictionary)dict.objectForKey("Remote")), dict.containsKey("Argument") ? new RecursivePathSerializer().deserialize((NSDictionary)dict.objectForKey("Argument")) : null, dict.containsKey("Attributes") ? new PathAttributesDictionary().deserialize((Object)dict.objectForKey("Attributes")) : null);
        if (dict.containsKey("Length")) {
            op.withLength((Long)dict.objectForKey("Length").toJavaObject(Long.class));
        }
        if (dict.containsKey("Checksum")) {
            op.withChecksum(Checksum.parse((String)dict.objectForKey("Checksum").toString()));
        }
        if (dict.containsKey("Application")) {
            op.withApplication(new Application(dict.objectForKey("Application").toString()));
        }
        return op;
    }
}

