/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.metadata;

import ch.cyberduck.core.Local;
import ch.iterate.mountainduck.sync.metadata.BinaryPlistFileMetadataReader;
import ch.iterate.mountainduck.sync.metadata.BinaryPlistFileMetadataWriter;
import ch.iterate.mountainduck.sync.metadata.FileMetadataReader;
import ch.iterate.mountainduck.sync.metadata.FileMetadataWriter;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import com.dd.plist.NSDictionary;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultMetadataService
implements MetadataService<NSDictionary> {
    private static final Logger log = LogManager.getLogger((String)DefaultMetadataService.class.getName());
    private final MetadataStorage storage;
    private final FileMetadataReader<NSDictionary> reader;
    private final FileMetadataWriter<NSDictionary> writer;

    public DefaultMetadataService(MetadataStorage storage) {
        this(storage, new BinaryPlistFileMetadataReader(), new BinaryPlistFileMetadataWriter());
    }

    public DefaultMetadataService(MetadataStorage storage, FileMetadataReader<NSDictionary> reader, FileMetadataWriter<NSDictionary> writer) {
        this.storage = storage;
        this.reader = reader;
        this.writer = writer;
    }

    @Override
    public void close() {
        this.storage.close();
    }

    @Override
    public Future<Boolean> write(Local file, MetadataStorage.Key key, NSDictionary dictionary) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Write metadata %s for file %s", new Object[]{key, file}));
        }
        try {
            this.storage.set(file, key, this.writer.write(file, dictionary));
            return ConcurrentUtils.constantFuture((Object)true);
        }
        catch (IOException e) {
            log.warn(String.format("Failure %s writing %s attributes for %s", new Object[]{e, key, file}));
            return ConcurrentUtils.constantFuture((Object)false);
        }
    }

    @Override
    public NSDictionary read(Local file, MetadataStorage.Key key) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Read metadata %s for file %s", new Object[]{key, file}));
        }
        try {
            ByteBuffer value = this.storage.get(file, key);
            return this.reader.read(value);
        }
        catch (IOException e) {
            log.error(String.format("Failure %s reading %s attributes for %s", new Object[]{e, key, file}));
            return null;
        }
    }

    @Override
    public Future<Boolean> delete(Local file, MetadataStorage.Key key) {
        try {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Delete metadata %s for file %s", new Object[]{key, file}));
            }
            this.storage.delete(file, key);
            return ConcurrentUtils.constantFuture((Object)true);
        }
        catch (IOException e) {
            log.warn(String.format("Failure %s deleting %s attributes for %s", new Object[]{e, key, file}));
            return ConcurrentUtils.constantFuture((Object)false);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultMetadataService{");
        sb.append("storage=").append(this.storage);
        sb.append('}');
        return sb.toString();
    }
}

