/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.metadata;

import ch.cyberduck.core.date.RFC1123DateFormatter;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.threading.DefaultFailureDiagnostics;
import ch.cyberduck.core.threading.FailureDiagnostics;
import ch.iterate.mountainduck.sync.metadata.DefaultOperationSerializer;
import ch.iterate.mountainduck.sync.metadata.ExceptionSerializer;
import ch.iterate.mountainduck.sync.queue.SerializableOperation;
import ch.iterate.mountainduck.sync.queue.SerializableOperationException;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import java.util.TimeZone;

public class DefaultExceptionSerializer
implements ExceptionSerializer<NSDictionary> {
    @Override
    public NSDictionary serialize(SerializableOperation operation, BackgroundException failure) {
        NSDictionary dict = new NSDictionary();
        dict.put("timestamp", (Object)new RFC1123DateFormatter().format(System.currentTimeMillis(), TimeZone.getTimeZone("UTC")));
        dict.put("type", (Object)new DefaultFailureDiagnostics().determine(failure).name());
        dict.put("class", (Object)((Object)((Object)failure)).getClass().getName());
        dict.put("message", (Object)failure.getMessage());
        dict.put("detail", (Object)failure.getDetail(false));
        dict.put("operation", (NSObject)new DefaultOperationSerializer().serialize(operation));
        return dict;
    }

    @Override
    public SerializableOperationException deserialize(NSDictionary failure) {
        return new SerializableOperationException(new DefaultOperationSerializer().deserialize((NSDictionary)failure.get((Object)"operation")), failure.containsKey("type") ? FailureDiagnostics.Type.valueOf((String)failure.get((Object)"type").toString()) : FailureDiagnostics.Type.application, failure.containsKey("class") ? failure.get((Object)"class").toString() : "", failure.containsKey("message") ? failure.get((Object)"message").toString() : "", failure.containsKey("detail") ? failure.get((Object)"detail").toString() : "");
    }
}

