/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.metadata;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.cache.LRUCache;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.sync.metadata.MetadataService;
import ch.iterate.mountainduck.sync.metadata.MetadataStorage;
import com.dd.plist.NSDictionary;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.lang3.concurrent.ConcurrentUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CachingMetadataService
implements MetadataService<NSDictionary> {
    private static final Logger log = LogManager.getLogger((String)CachingMetadataService.class.getName());
    private static final NSDictionary EMPTY = new NSDictionary();
    private final LRUCache<CacheKey, NSDictionary> cache;
    private final MetadataService<NSDictionary> proxy;

    public CachingMetadataService(MetadataService<NSDictionary> proxy) {
        this(proxy, PreferencesFactory.get().getLong("fs.sync.metadata.cache.size"));
    }

    public CachingMetadataService(MetadataService<NSDictionary> proxy, long capacity) {
        this.proxy = proxy;
        this.cache = LRUCache.usingLoader(this::load, (long)capacity);
    }

    @Override
    public Future<Boolean> write(Local file, MetadataStorage.Key key, NSDictionary dictionary) {
        NSDictionary current;
        CacheKey cacheKey = new CacheKey(file, key);
        if (this.cache.contains((Object)cacheKey) && null != (current = this.read(file, key)) && dictionary.equals((Object)current)) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Skip write of %s for %s", new Object[]{key, file}));
            }
            return ConcurrentUtils.constantFuture((Object)true);
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Write %s for %s", new Object[]{key, file}));
        }
        Future<Boolean> result = this.proxy.write(file, key, dictionary);
        try {
            if (result.get().booleanValue()) {
                this.cache.put((Object)cacheKey, (Object)dictionary);
            } else {
                log.warn(String.format("Do not cache %s for file %s", new Object[]{key, file}));
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public NSDictionary read(Local file, MetadataStorage.Key key) {
        NSDictionary dict = (NSDictionary)this.cache.get((Object)new CacheKey(file, key));
        if (EMPTY == dict) {
            return null;
        }
        return dict;
    }

    @Override
    public Future<Boolean> delete(Local file, MetadataStorage.Key key) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Delete %s from cache for %s", new Object[]{key, file}));
        }
        this.cache.remove((Object)new CacheKey(file, key));
        return this.proxy.delete(file, key);
    }

    @Override
    public void close() {
        this.cache.clear();
        this.proxy.close();
    }

    @Override
    public void flush(Local file) {
        this.proxy.flush(file);
    }

    @Override
    public MetadataService<NSDictionary> open(Local directory) {
        this.proxy.open(directory);
        return this;
    }

    private NSDictionary load(CacheKey key) {
        switch (key.key) {
            case delete: 
            case rename: {
                return EMPTY;
            }
        }
        NSDictionary dict = this.proxy.read(key.file, key.key);
        if (null == dict) {
            return EMPTY;
        }
        return dict;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CachingMetadataService{");
        sb.append("cache=").append(this.cache);
        sb.append('}');
        return sb.toString();
    }

    private static final class CacheKey {
        final Local file;
        final MetadataStorage.Key key;

        public CacheKey(Local file, MetadataStorage.Key key) {
            this.file = file;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.file, cacheKey.file) && this.key == cacheKey.key;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.file, this.key});
        }
    }
}

