/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.metadata;

import ch.iterate.mountainduck.sync.metadata.FileMetadataReader;
import com.dd.plist.BinaryPropertyListParser;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListFormatException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BinaryPlistFileMetadataReader
implements FileMetadataReader<NSDictionary> {
    private static final Logger log = LogManager.getLogger((String)BinaryPlistFileMetadataReader.class.getName());

    @Override
    public NSDictionary read(ByteBuffer value) {
        try {
            if (null == value) {
                return null;
            }
            NSObject dictionary = BinaryPropertyListParser.parse((byte[])value.array());
            return (NSDictionary)dictionary;
        }
        catch (PropertyListFormatException | UnsupportedEncodingException | ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            log.warn(String.format("Failure reading extended attributes for %s", value));
            return null;
        }
    }
}

