/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.history;

import ch.cyberduck.core.Factory;
import ch.cyberduck.core.FactoryException;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.sync.history.FileHistory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileHistoryFactory
extends Factory<FileHistory> {
    private static final Logger log = LogManager.getLogger((String)FileHistoryFactory.class.getName());

    protected FileHistoryFactory() {
        super("factory.sync.history.class");
    }

    public static FileHistory get(Local directory) {
        return new FileHistoryFactory().create(directory);
    }

    private FileHistory create(Local directory) {
        String clazz = PreferencesFactory.get().getProperty("factory.sync.history.class");
        if (null == clazz) {
            throw new FactoryException(String.format("No implementation given for factory %s", ((Object)((Object)this)).getClass().getSimpleName()));
        }
        try {
            Class<?> name = Class.forName(clazz);
            Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor(name, (Class[])new Class[]{directory.getClass()});
            return (FileHistory)constructor.newInstance(directory);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException var6) {
            log.error(String.format("Failure loading callback class %s. %s", clazz, var6.getMessage()));
            throw new FactoryException();
        }
    }
}

