/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.history;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.local.Application;
import ch.iterate.mountainduck.sync.queue.Operation;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public interface FileHistory {
    public static final FileHistory EMPTY = new FileHistory(){

        @Override
        public void open() {
        }

        @Override
        public void close() {
        }

        @Override
        public void add(Item item) {
        }

        @Override
        public List<Item> find(int n) {
            return Collections.emptyList();
        }

        @Override
        public void clear() {
        }
    };

    public void open() throws BackgroundException;

    public void close() throws BackgroundException;

    public void add(Item var1);

    public List<Item> find(int var1);

    public void clear();

    public static class Item {
        public final Path remote;
        public final Local local;
        public final Origin origin;
        public final Operation operation;
        public final Long timestamp;
        public Application application;
        public BackgroundException failure;

        public Item(Path remote, Local local, Origin origin, Operation operation) {
            this(remote, local, origin, operation, System.currentTimeMillis());
        }

        public Item(Path remote, Local local, Origin origin, Operation operation, Long timestamp) {
            this(remote, local, origin, operation, timestamp, Application.notfound);
        }

        public Item(Path remote, Local local, Origin origin, Operation operation, Application application) {
            this(remote, local, origin, operation, System.currentTimeMillis(), application);
        }

        public Item(Path remote, Local local, Origin origin, Operation operation, Long timestamp, Application application) {
            this(remote, local, origin, operation, timestamp, application, null);
        }

        public Item(Path remote, Local local, Origin origin, Operation operation, Long timestamp, Application application, BackgroundException failure) {
            this.remote = remote;
            this.local = local;
            this.origin = origin;
            this.operation = operation;
            this.timestamp = timestamp;
            this.application = application;
            this.failure = failure;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)o;
            return Objects.equals(this.remote, item.remote) && Objects.equals(this.local, item.local) && this.origin == item.origin && this.operation == item.operation;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.remote, this.local, this.origin, this.operation});
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Item{");
            sb.append("remote=").append(this.remote);
            sb.append(", local=").append(this.local);
            sb.append(", origin=").append((Object)this.origin);
            sb.append(", operation=").append((Object)this.operation);
            sb.append(", timestamp=").append(this.timestamp);
            sb.append(", application=").append(this.application);
            sb.append('}');
            return sb.toString();
        }

        public static enum Origin {
            local,
            remote;


            public static Origin fromOperation(Operation operation) {
                return operation == Operation.read ? remote : local;
            }
        }
    }
}

