/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.sync.cache;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.local.LocalTrashFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.Worker;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.fs.FilesystemListProgressListener;
import ch.iterate.mountainduck.fs.buffer.MarkerBuffer;
import ch.iterate.mountainduck.fs.buffer.NullBuffer;
import ch.iterate.mountainduck.sync.cache.CacheEncryptor;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface LocalCache<Inode>
extends FilesystemCallbacks<Inode>,
CacheEncryptor {
    public static final Logger log = LogManager.getLogger((String)LocalCache.class.getName());
    public static final LocalCache EMPTY = new LocalCache(){

        @Override
        public Local getDirectory() {
            return null;
        }

        @Override
        public Long getSize() {
            return 0L;
        }

        @Override
        public LocalCache open(Path workdir, Local mountpoint) {
            return this;
        }

        @Override
        public void close() {
        }

        @Override
        public Path toRemote(Path file) {
            return file;
        }

        @Override
        public Local toMount(Path file) {
            return null;
        }

        @Override
        public Local toLocal(Path file, boolean resolve) {
            return null;
        }

        @Override
        public EnumSet<AbstractPath.Type> type(Path file) {
            return file.getType();
        }

        @Override
        public EnumSet<AbstractPath.Type> type(Local local) {
            return local.getType();
        }

        @Override
        public PathAttributes getattr(Path file, boolean cached) {
            return file.attributes();
        }

        @Override
        public PathAttributes getattr(Local local) {
            return PathAttributes.EMPTY;
        }

        @Override
        public void invalidate(Path file) {
        }

        public void setattr(Path file, EnumSet type, PathAttributes attributes, boolean prune) {
        }

        @Override
        public void placeholder(Path file, PathAttributes attributes) throws BackgroundException {
            throw new UnsupportedException();
        }

        @Override
        public Set<Path> trash(Path file) throws BackgroundException {
            return Collections.emptySet();
        }

        @Override
        public Version version() {
            return null;
        }

        @Override
        public State getState() {
            return State.closed;
        }

        @Override
        public Path find(Path directory, String filename, FilesystemCallbacks.Flags flags) throws BackgroundException {
            throw new UnsupportedException();
        }

        @Override
        public MarkerBuffer buffer(Path file) {
            return new NullBuffer();
        }

        @Override
        public void open(Path file, FilesystemCallbacks.Mode flags, Long allocate, Application application) throws BackgroundException {
            throw new UnsupportedException();
        }

        @Override
        public boolean contains(Path file, FilesystemCallbacks.Mode flags) {
            return false;
        }

        @Override
        public TransferStatus close(Path file, FilesystemCallbacks.Mode flags, Application application, boolean releaseLock) throws BackgroundException {
            throw new UnsupportedException();
        }

        @Override
        public Object touch(Path file) throws BackgroundException {
            throw new UnsupportedException();
        }

        @Override
        public void truncate(Path file, long size) throws BackgroundException {
            throw new UnsupportedException();
        }

        @Override
        public Object mkdir(Path directory) throws BackgroundException {
            throw new UnsupportedException();
        }

        @Override
        public Object symlink(Path file, Path target) throws BackgroundException {
            throw new UnsupportedException();
        }

        @Override
        public Map<Path, Path> rename(Path file, Path target) {
            return Collections.emptyMap();
        }

        @Override
        public Set<Path> delete(Path file) {
            return Collections.emptySet();
        }

        @Override
        public Worker<AttributedList<Path>> list(Path directory, FilesystemListProgressListener listener, long fromCookie) throws BackgroundException {
            throw new UnsupportedException();
        }

        @Override
        public Path search(Path directory, String filename) throws BackgroundException {
            throw new UnsupportedException();
        }

        @Override
        public boolean setattr(Path file, long timestamp) {
            return false;
        }

        @Override
        public boolean setattr(Path file, Permission permission) {
            return false;
        }

        @Override
        public int read(Path file, byte[] chunk, long offset, int count) {
            return 0;
        }

        @Override
        public int write(Path file, byte[] chunk, int count, long offset) {
            return 0;
        }

        @Override
        public Quota.Space quota(Path workdir) throws BackgroundException {
            throw new UnsupportedException();
        }

        @Override
        public Object lock(Path file) throws BackgroundException {
            throw new UnsupportedException();
        }

        @Override
        public void unlock(Path file) throws BackgroundException {
            throw new UnsupportedException();
        }

        @Override
        public String getLock(Path file) {
            return null;
        }

        @Override
        public long toCiphertextSize(long cleartextFileSize) {
            return cleartextFileSize;
        }

        @Override
        public long toCleartextSize(long ciphertextFileSize) {
            return ciphertextFileSize;
        }
    };

    public Local getDirectory();

    public Long getSize();

    @Override
    public LocalCache<Inode> open(Path var1, Local var2) throws BackgroundException;

    @Override
    public void close() throws BackgroundException;

    public Path toRemote(Path var1);

    public Local toMount(Path var1);

    default public Local toLocal(Path file) {
        return this.toLocal(file, false);
    }

    public Local toLocal(Path var1, boolean var2);

    @Override
    public EnumSet<AbstractPath.Type> type(Path var1);

    public EnumSet<AbstractPath.Type> type(Local var1);

    public PathAttributes getattr(Local var1);

    public Path search(Path var1, String var2) throws BackgroundException;

    @Override
    public void invalidate(Path var1);

    default public void setattr(Path file, EnumSet<AbstractPath.Type> type, PathAttributes attributes) {
        this.setattr(file, type, attributes, false);
    }

    public void setattr(Path var1, EnumSet<AbstractPath.Type> var2, PathAttributes var3, boolean var4);

    public void placeholder(Path var1, PathAttributes var2) throws BackgroundException;

    public Set<Path> trash(Path var1) throws BackgroundException;

    public Version version();

    public State getState();

    public static void cleanup(Host bookmark) {
        Local directory = LocalCache.directory(bookmark);
        if (directory.exists()) {
            log.warn(String.format("Delete cache %s for bookmark %s", directory, bookmark));
            try {
                LocalTrashFactory.get().trash(directory);
            }
            catch (AccessDeniedException e) {
                log.warn(String.format("Ignore failure trashing cache directory %s", directory));
            }
        }
    }

    public static Local directory(Host bookmark) {
        return LocalFactory.get((Local)LocalFactory.get((String)PreferencesFactory.get().getProperty("fs.sync.cache.directory")).withBookmark(PreferencesFactory.get().getProperty("fs.sync.cache.directory.bookmark")), (String)bookmark.getUuid());
    }

    public static enum State {
        open,
        closed;

    }

    public static enum Type {
        cleartext,
        encrypted;

    }

    public static class Version {
        public final Type type;
        public final int version;

        public Version(Type type, int version) {
            this.type = type;
            this.version = version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Version version1 = (Version)o;
            return this.version == version1.version && this.type == version1.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.version});
        }
    }
}

