/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.service;

import ch.cyberduck.core.Factory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.fs.FilesystemOperations;
import ch.iterate.mountainduck.service.DisabledVolumeIconService;
import ch.iterate.mountainduck.service.VolumeIconService;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VolumeIconServiceFactory
extends Factory<VolumeIconService> {
    private static final Logger log = LogManager.getLogger(VolumeIconServiceFactory.class);

    protected VolumeIconServiceFactory() {
        super("factory.volumeiconservice.class");
    }

    public VolumeIconService create(FilesystemOperations<?> fs) {
        try {
            Constructor constructor = ConstructorUtils.getMatchingAccessibleConstructor((Class)this.clazz, (Class[])new Class[]{fs.getClass()});
            if (null == constructor) {
                log.warn(String.format("No matching constructor for parameter %s", fs.getClass()));
                return (VolumeIconService)this.clazz.newInstance();
            }
            return (VolumeIconService)constructor.newInstance(fs);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            log.error(String.format("Failure loading class %s. %s", this.clazz, e.getMessage()));
            return new DisabledVolumeIconService();
        }
    }

    public static VolumeIconService get(FilesystemOperations<?> fs) {
        if (PreferencesFactory.get().getBoolean("mount.volume.icon.enable")) {
            return new VolumeIconServiceFactory().create(fs);
        }
        return new DisabledVolumeIconService();
    }
}

