/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.service;

import ch.cyberduck.core.transfer.TransferProgress;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.fs.FilesystemMountRegistry;
import ch.iterate.mountainduck.indexer.DirectoryIndexer;
import ch.iterate.mountainduck.service.BackgroundStatusListener;
import ch.iterate.mountainduck.sync.queue.SyncQueue;
import java.util.Set;

public class MountRegistryBackgroundStatusListener
implements BackgroundStatusListener {
    private final BackgroundStatusListener proxy;

    public MountRegistryBackgroundStatusListener(BackgroundStatusListener proxy) {
        this.proxy = proxy;
    }

    @Override
    public void refresh(SyncQueue.Status status) {
        switch (status) {
            case stopped: 
            case pausing: {
                Set<Filesystem> mountpoints = FilesystemMountRegistry.get().values();
                if (mountpoints.size() > 1) {
                    for (Filesystem m : mountpoints) {
                        SyncQueue.Status q = m.getQueue().getStatus();
                        switch (q) {
                            case busy: {
                                this.proxy.refresh(q);
                            }
                        }
                    }
                    break;
                }
                this.proxy.refresh(status);
                break;
            }
            default: {
                this.proxy.refresh(status);
            }
        }
    }

    @Override
    public void refresh(DirectoryIndexer.Status status) {
        this.proxy.refresh(status);
    }

    @Override
    public void refresh(TransferProgress progress) {
        this.proxy.refresh(progress);
    }
}

