/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.service;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.preferences.LogDirectoryFinderFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.service.ThreadDumpService;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JmxThreadDumpService
implements ThreadDumpService {
    private static final Logger log = LogManager.getLogger((String)JmxThreadDumpService.class.getName());

    @Override
    public void dump() {
        Local file = LocalFactory.get((String)LogDirectoryFinderFactory.get().find().getAbsolute(), (String)String.format("%s.dmp", StringUtils.replaceChars((String)StringUtils.lowerCase((String)PreferencesFactory.get().getProperty("application.name")), (String)" ", (String)"")));
        try (OutputStream out = file.getOutputStream(false);){
            for (ThreadInfo threadInfo : ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)) {
                IOUtils.write((String)threadInfo.toString(), (OutputStream)out, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (AccessDeniedException | IOException e) {
            log.error(String.format("Failure writing thread ddump to %s", file));
        }
    }
}

