/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.service;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.iterate.mountainduck.fs.Filesystem;
import ch.iterate.mountainduck.service.ReloadService;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InvalidatingReloadService
implements ReloadService {
    private static final Logger log = LogManager.getLogger((String)InvalidatingReloadService.class.getName());
    private final Filesystem fs;

    public InvalidatingReloadService(Filesystem fs) {
        this.fs = fs;
    }

    @Override
    public void reload(Path selected, Local local, Map<Path, ReloadService.Change> files) {
        Path directory;
        if (selected.isFile()) {
            if (log.isInfoEnabled()) {
                log.info(String.format("Invalidate file %s", selected));
            }
            this.fs.getOperations().invalidate(selected);
        }
        Path path = directory = selected.isFile() ? selected.getParent() : selected;
        if (log.isInfoEnabled()) {
            log.info(String.format("Invalidate directory %s", directory));
        }
        this.fs.getOperations().invalidate(directory);
        ReloadService proxy = this.fs.getReloadService();
        proxy.reload(selected, local, files);
    }
}

