/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.registration;

import ch.cyberduck.core.aquaticprime.InvalidLicenseException;
import ch.cyberduck.core.aquaticprime.License;
import ch.cyberduck.core.aquaticprime.LicenseVerifier;
import ch.cyberduck.core.aquaticprime.LicenseVerifierCallback;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.iterate.mountainduck.registration.UpgradeLicenseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpgradeLicenseVerifier
implements LicenseVerifier {
    private static final Logger log = LogManager.getLogger((String)UpgradeLicenseVerifier.class.getName());
    private static final Integer DEFAULT_VERSION = 1;
    private final License license;

    public UpgradeLicenseVerifier(License license) {
        this.license = license;
    }

    public boolean verify(LicenseVerifierCallback callback) {
        if (this.license.isReceipt()) {
            return true;
        }
        String versionString = this.license.getValue("Version");
        Integer version = StringUtils.isNotBlank((CharSequence)versionString) ? Integer.valueOf(StringUtils.substring((String)versionString, (int)0, (int)1)) : DEFAULT_VERSION;
        Integer installed = Integer.valueOf(StringUtils.substring((String)PreferencesFactory.get().getProperty("application.version"), (int)0, (int)1));
        if (installed > version) {
            log.warn(String.format("Registration key issued for version %s not valid for installed version %s", version, installed));
            callback.failure((InvalidLicenseException)new UpgradeLicenseException());
            return false;
        }
        return true;
    }
}

