/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.registration;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.CertificateIdentityCallbackFactory;
import ch.cyberduck.core.CertificateStoreFactory;
import ch.cyberduck.core.CertificateTrustCallbackFactory;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.ConnectionService;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.DisabledHostKeyCallback;
import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostParser;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.PasswordCallbackFactory;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionPoolFactory;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.aquaticprime.License;
import ch.cyberduck.core.aquaticprime.LicenseVerifierCallback;
import ch.cyberduck.core.dav.DAVSSLProtocol;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.HostParserException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.io.StreamCopier;
import ch.cyberduck.core.io.StreamProgress;
import ch.cyberduck.core.local.DefaultLocalTouchFeature;
import ch.cyberduck.core.local.TemporaryFileServiceFactory;
import ch.cyberduck.core.preferences.SupportDirectoryFinderFactory;
import ch.cyberduck.core.proxy.ProxyFactory;
import ch.cyberduck.core.ssl.DefaultTrustManagerHostnameCallback;
import ch.cyberduck.core.ssl.KeychainX509KeyManager;
import ch.cyberduck.core.ssl.KeychainX509TrustManager;
import ch.cyberduck.core.ssl.TrustManagerHostnameCallback;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.BackgroundAction;
import ch.cyberduck.core.threading.CancelCallback;
import ch.cyberduck.core.threading.ControllerBackgroundAction;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.vault.VaultRegistry;
import ch.cyberduck.core.vault.VaultRegistryFactory;
import ch.iterate.mountainduck.registration.MacUniqueIdService;
import ch.iterate.mountainduck.registration.MountainduckLicenseKey;
import ch.iterate.mountainduck.registration.UniqueIdService;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TrialKeyLicenseService {
    private static final Logger log = LogManager.getLogger((String)TrialKeyLicenseService.class.getName());
    private final Controller controller;
    private final UniqueIdService uuid;

    public TrialKeyLicenseService(Controller controller) {
        this(controller, new MacUniqueIdService());
    }

    public TrialKeyLicenseService(Controller controller, UniqueIdService uuid) {
        this.controller = controller;
        this.uuid = uuid;
    }

    public void install(Callback callback) {
        try {
            Host resource = new HostParser(new ProtocolFactory(Collections.singleton(new DAVSSLProtocol(){

                public boolean isEnabled() {
                    return true;
                }
            }))).get("https://reg.mountainduck.io/trial");
            if (log.isInfoEnabled()) {
                log.info(String.format("Fetch trial license from %s", resource));
            }
            this.download(callback, resource);
        }
        catch (HostParserException e) {
            log.error(e.getDetail());
        }
    }

    protected Future<License> download(final Callback callback, final Host resource) {
        return this.controller.background((BackgroundAction)new ControllerBackgroundAction<License>(this.controller, SessionPoolFactory.create((ConnectionService)new SimpleConnectionService(), (TranscriptListener)this.controller, (Host)resource, (X509TrustManager)new KeychainX509TrustManager(CertificateTrustCallbackFactory.get((Controller)this.controller), (TrustManagerHostnameCallback)new DefaultTrustManagerHostnameCallback(resource), CertificateStoreFactory.get()), (X509KeyManager)new KeychainX509KeyManager(CertificateIdentityCallbackFactory.get((Controller)this.controller), resource, CertificateStoreFactory.get()), (VaultRegistry)VaultRegistryFactory.create((HostPasswordStore)PasswordStoreFactory.get(), (PasswordCallback)PasswordCallbackFactory.get((Controller)this.controller)), (SessionPoolFactory.Usage[])new SessionPoolFactory.Usage[]{SessionPoolFactory.Usage.transfer})){

            public License run(Session<?> connection) throws BackgroundException {
                Read read = (Read)connection.getFeature(Read.class);
                TransferStatus options = new TransferStatus();
                options.withParameters(Collections.singletonMap("uuid", TrialKeyLicenseService.this.uuid.getUUID()));
                InputStream in = read.read(new Path(resource.getDefaultPath(), EnumSet.of(AbstractPath.Type.file)), options, (ConnectionCallback)new DisabledConnectionCallback());
                Local temporary = TemporaryFileServiceFactory.get().create(String.format("%s.mountainducklicense", TrialKeyLicenseService.this.uuid.getUUID()));
                new DefaultLocalTouchFeature().touch(temporary);
                OutputStream out = temporary.getOutputStream(false);
                TransferStatus status = new TransferStatus().withLength(-1L);
                if (log.isInfoEnabled()) {
                    log.info(String.format("Copying trial license to %s", temporary));
                }
                new StreamCopier((StreamCancelation)status, (StreamProgress)status).transfer(in, out);
                MountainduckLicenseKey trial = new MountainduckLicenseKey(temporary);
                trial.verify(callback);
                Local target = LocalFactory.get((Local)SupportDirectoryFinderFactory.get().find(), (String)temporary.getName());
                temporary.copy(target);
                if (log.isInfoEnabled()) {
                    log.info(String.format("Installed trial license to %s", target));
                }
                callback.installed((License)trial);
                return trial;
            }
        });
    }

    public static interface Callback
    extends LicenseVerifierCallback {
        public void installed(License var1);
    }

    private static final class SimpleConnectionService
    implements ConnectionService {
        private SimpleConnectionService() {
        }

        public boolean check(Session<?> session, CancelCallback callback) throws BackgroundException {
            if (session.isConnected()) {
                return false;
            }
            this.connect(session, callback);
            return true;
        }

        public void connect(Session<?> session, CancelCallback cancel) throws BackgroundException {
            session.open(ProxyFactory.get().find(session.getHost().getHostname()), (HostKeyCallback)new DisabledHostKeyCallback(), (LoginCallback)new DisabledLoginCallback(), cancel);
        }

        public void close(Session<?> session) {
            try {
                session.close();
            }
            catch (BackgroundException e) {
                log.warn(String.format("Ignore failure closing connection %s", e.getMessage()));
            }
        }
    }
}

