/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.registration;

import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.aquaticprime.DisabledLicenseVerifierCallback;
import ch.cyberduck.core.aquaticprime.License;
import ch.cyberduck.core.aquaticprime.LicenseFactory;
import ch.cyberduck.core.aquaticprime.LicenseVerifierCallback;
import ch.cyberduck.core.aquaticprime.Receipt;
import ch.cyberduck.core.aquaticprime.ReceiptVerifier;
import ch.cyberduck.core.date.ISO8601DateParser;
import ch.cyberduck.core.date.InvalidDateException;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.preferences.ApplicationResourcesFinderFactory;
import ch.cyberduck.core.preferences.SupportDirectoryFinderFactory;
import ch.iterate.mountainduck.registration.MountainduckLicenseKey;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MountainduckLicenseFactory
extends LicenseFactory {
    private static final Logger log = LogManager.getLogger((String)MountainduckLicenseFactory.class.getName());

    public MountainduckLicenseFactory() {
        super(SupportDirectoryFinderFactory.get().find(), (Filter)new LicenseFilter());
    }

    protected License open(Local l) {
        return new MountainduckLicenseKey(l);
    }

    public List<License> open() throws AccessDeniedException {
        Local bundle;
        List keys = super.open();
        if (keys.isEmpty() && (bundle = ApplicationResourcesFinderFactory.get().find()).exists()) {
            for (Local key : bundle.list().filter((Filter)new LicenseFilter())) {
                log.info(String.format("Add bundled registration key %s", key));
                License registration = this.open(key);
                keys.add(registration);
            }
        }
        this.sortByVersionExpiry(keys);
        if (keys.isEmpty()) {
            for (Local file : SupportDirectoryFinderFactory.get().find().list().filter((Filter)new Filter<Local>(){

                public boolean accept(Local file) {
                    return "cyberduckreceipt".equals(Path.getExtension((String)file.getName()));
                }

                public Pattern toPattern() {
                    return Pattern.compile(".*\\.cyberduckreceipt");
                }
            })) {
                ReceiptVerifier verifier = new ReceiptVerifier(file);
                if (!verifier.verify((LicenseVerifierCallback)new DisabledLicenseVerifierCallback())) continue;
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Found receipt %s", file));
                }
                keys.add(new Receipt(file, verifier.getGuid()));
            }
            if (keys.isEmpty()) {
                log.warn("No valid license key found");
                return Collections.singletonList(EMPTY_LICENSE);
            }
            log.info("Found valid receipt");
        }
        return keys;
    }

    protected void sortByVersionExpiry(List<License> keys) {
        keys.sort(Collections.reverseOrder(new Comparator<License>(){

            @Override
            public int compare(License o1, License o2) {
                try {
                    Date e2;
                    String v1 = StringUtils.isEmpty((String)o1.getValue("Version")) ? "1" : o1.getValue("Version");
                    String v2 = StringUtils.isEmpty((String)o2.getValue("Version")) ? "1" : o2.getValue("Version");
                    Date e1 = StringUtils.isEmpty((String)o1.getValue("Expiry")) ? new Date(Long.MAX_VALUE) : new ISO8601DateParser().parse(o1.getValue("Expiry"));
                    Date date = e2 = StringUtils.isEmpty((String)o2.getValue("Expiry")) ? new Date(Long.MAX_VALUE) : new ISO8601DateParser().parse(o2.getValue("Expiry"));
                    if (v1.compareTo(v2) == 0) {
                        return e1.compareTo(e2);
                    }
                    return v1.compareTo(v2);
                }
                catch (InvalidDateException e) {
                    log.error(String.format("Failure parsing expiry in registration key. %s", e.getMessage()));
                    return 0;
                }
            }
        }));
    }

    protected License create() {
        return new LicenseFactory.DefaultLicenseFactory((LicenseFactory)this).create();
    }

    private static final class LicenseFilter
    implements Filter<Local> {
        private LicenseFilter() {
        }

        public boolean accept(Local file) {
            return "mountainducklicense".equalsIgnoreCase(FilenameUtils.getExtension((String)file.getName()));
        }

        public Pattern toPattern() {
            return Pattern.compile(".*\\.mountainducklicense");
        }
    }
}

