/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.registration;

import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.iterate.mountainduck.registration.UniqueIdService;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.commons.codec.binary.Hex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MacUniqueIdService
implements UniqueIdService {
    private static final Logger log = LogManager.getLogger((String)MacUniqueIdService.class.getName());

    @Override
    public String getUUID() throws LocalAccessDeniedException {
        try {
            NetworkInterface in = NetworkInterface.getByInetAddress(InetAddress.getLocalHost());
            if (null == in) {
                return this.enumerate();
            }
            byte[] address = in.getHardwareAddress();
            if (null == address) {
                return this.enumerate();
            }
            return this.toHex(address);
        }
        catch (SocketException | UnknownHostException e) {
            throw new LocalAccessDeniedException(e.getMessage(), (Throwable)e);
        }
    }

    protected String enumerate() throws SocketException, LocalAccessDeniedException {
        log.warn("Missing loopback network interface");
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface n = interfaces.nextElement();
            if (log.isDebugEnabled()) {
                log.debug(String.format("Found network interface %s", n));
            }
            if (n.getHardwareAddress() == null) continue;
            return this.toHex(n.getHardwareAddress());
        }
        throw new LocalAccessDeniedException("Missing default network interface");
    }

    private String toHex(byte[] hardwareAddress) throws SocketException {
        return Hex.encodeHexString((byte[])hardwareAddress);
    }
}

