/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.registration;

import ch.cyberduck.core.aquaticprime.License;
import ch.cyberduck.core.aquaticprime.LicenseFactory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.updater.UpdateCheckerArguments;
import ch.iterate.mountainduck.registration.DisabledLicenseFactory;
import ch.iterate.mountainduck.registration.MacUniqueIdService;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LicensingUpdateCheckerArguments
implements UpdateCheckerArguments {
    private static final Logger log = LogManager.getLogger((String)LicensingUpdateCheckerArguments.class.getName());

    public Map<String, String> build() {
        HashMap<String, String> args = new HashMap<String, String>();
        License license = LicenseFactory.find();
        if (!DisabledLicenseFactory.DISABLED_LICENSE.equals(license)) {
            String tx = license.getValue("Transaction");
            if (StringUtils.isNotBlank((CharSequence)tx)) {
                args.put("registration", tx);
            } else {
                args.put("registration", "invalid");
            }
        } else {
            args.put("registration", "disabled");
        }
        try {
            args.put("guid", ChecksumComputeFactory.get((HashAlgorithm)HashAlgorithm.md5).compute((String)new MacUniqueIdService().getUUID()).hash);
        }
        catch (BackgroundException e) {
            log.warn(String.format("Failure %s determining MAC address", new Object[]{e}));
        }
        return args;
    }
}

