/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.registration;

import ch.cyberduck.core.aquaticprime.InvalidLicenseException;
import ch.cyberduck.core.aquaticprime.License;
import ch.cyberduck.core.aquaticprime.LicenseVerifier;
import ch.cyberduck.core.aquaticprime.LicenseVerifierCallback;
import ch.iterate.mountainduck.registration.ExpiredLicenseException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExpiryLicenseVerifier
implements LicenseVerifier {
    private static final Logger log = LogManager.getLogger((String)ExpiryLicenseVerifier.class.getName());
    private final License license;

    public ExpiryLicenseVerifier(License license) {
        this.license = license;
    }

    public boolean verify(LicenseVerifierCallback callback) {
        if (this.license.isReceipt()) {
            return true;
        }
        String expiryString = this.license.getValue("Expiry");
        if (StringUtils.isNotBlank((CharSequence)expiryString)) {
            try {
                log.info(String.format("Validate expiry on %s", expiryString));
                LocalDate expiry = LocalDate.parse(expiryString, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                if (expiry.compareTo(LocalDate.now()) < 0) {
                    log.warn(String.format("Registration key expired on %s", expiryString));
                    callback.failure((InvalidLicenseException)new ExpiredLicenseException());
                    return false;
                }
            }
            catch (DateTimeParseException e) {
                log.warn(String.format("Failure parsing expiry date %s. %s", expiryString, e.getMessage()));
            }
        }
        return true;
    }
}

