/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.io;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.mountainduck.io.Marker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface WriteStrategy {
    public static final Logger log = LogManager.getLogger((String)WriteStrategy.class.getName());

    public StatusOutputStream write(Path var1, Long var2, Long var3) throws BackgroundException;

    public TransferStatus close(Path var1) throws BackgroundException;

    public boolean contains(Marker var1);

    public static PathAttributes toAttributes(Path file, TransferStatus reply) {
        if (reply != null) {
            if (!PathAttributes.EMPTY.equals((Object)reply.getResponse())) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Update attributes for %s from response %s", file, reply.getResponse()));
                }
                PathAttributes latest = new PathAttributes(file.attributes());
                latest.setVersionId(reply.getResponse().getVersionId());
                latest.setFileId(reply.getResponse().getFileId());
                latest.setChecksum(reply.getResponse().getChecksum());
                latest.setETag(reply.getResponse().getETag());
                if (-1L != reply.getResponse().getSize() && 0L != reply.getResponse().getSize()) {
                    latest.setSize(reply.getResponse().getSize());
                }
                if (-1L != reply.getResponse().getModificationDate()) {
                    latest.setModificationDate(reply.getResponse().getModificationDate());
                }
                if (-1L != reply.getResponse().getAccessedDate()) {
                    latest.setAccessedDate(reply.getResponse().getAccessedDate());
                }
                if (-1L != reply.getResponse().getCreationDate()) {
                    latest.setCreationDate(reply.getResponse().getCreationDate());
                }
                return latest;
            }
            log.warn(String.format("Missing response in transfer status for %s", file));
        } else {
            log.warn(String.format("Missing transfer status for %s", file));
        }
        return file.attributes();
    }

    public static class AppendUnsupportedException
    extends UnsupportedException {
        public AppendUnsupportedException(String detail) {
            super(detail);
        }
    }
}

