/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TrailBufferMarkerOutputStream
extends CountingOutputStream {
    private static final Logger log = LogManager.getLogger((String)TrailBufferMarkerOutputStream.class.getName());
    private final Map<Long, byte[]> chunks = new HashMap<Long, byte[]>();
    private final OutputStream proxy;
    private Long offset = 0L;

    public TrailBufferMarkerOutputStream(OutputStream proxy) {
        super(proxy);
        this.proxy = proxy;
    }

    public void setOffset(Long offset) {
        if (log.isInfoEnabled()) {
            log.info(String.format("Set offset for %s to %d", this.proxy, offset));
        }
        this.offset = offset;
    }

    public void write(int idx) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    public void write(byte[] buffer, int start, int len) throws IOException {
        if (this.getByteCount() == this.offset.longValue()) {
            super.write(buffer, start, len);
        } else {
            log.warn(String.format("Buffer chunk with length %d and offset %d", buffer.length, this.offset));
            this.chunks.put(this.offset, Arrays.copyOfRange(buffer, start, start + len));
        }
    }

    protected synchronized void beforeWrite(int n) {
        if (this.getByteCount() == this.offset.longValue()) {
            super.beforeWrite(n);
        }
    }

    protected void afterWrite(int n) throws IOException {
        long count = this.getByteCount();
        if (this.chunks.containsKey(count)) {
            byte[] chunk = this.chunks.get(count);
            log.warn(String.format("Write trailing buffer with length %d and offset %d", chunk.length, count));
            this.chunks.remove(count);
            super.beforeWrite(n);
            super.write(chunk, 0, chunk.length);
        }
    }

    public void close() throws IOException {
        super.close();
    }
}

