/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.io;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.fs.FilesystemOperations;
import ch.iterate.mountainduck.fs.FilesystemTimestampWorker;
import ch.iterate.mountainduck.io.CloseCallback;
import java.io.Closeable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TimestampCloseCallback
implements CloseCallback {
    private static final Logger log = LogManager.getLogger((String)TimestampCloseCallback.class.getName());
    private final FilesystemOperations<?> fs;

    public TimestampCloseCallback(FilesystemOperations<?> fs) {
        this.fs = fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void closed(Path file, TransferStatus status, Closeable stream, FilesystemCallbacks.Mode mode) throws BackgroundException {
        if (-1L == file.attributes().getModificationDate()) {
            log.warn(String.format("Skip updating timestamp for file %s", file));
            return;
        }
        if (file.attributes().getCustom().containsKey("set_modification_date")) {
            try {
                this.fs.getPool().execute(new FilesystemTimestampWorker(this.fs, file, file.attributes().getModificationDate()));
                if (PathAttributes.EMPTY.equals((Object)status.getResponse())) return;
                if (log.isWarnEnabled()) {
                    log.warn(String.format("Override modification date to %d in server reply %s", file.attributes().getModificationDate(), status.getResponse()));
                }
                status.getResponse().setModificationDate(file.attributes().getModificationDate());
                return;
            }
            catch (UnsupportedException e) {
                log.warn(String.format("Ignore failure %s", new Object[]{e}));
                return;
            }
            finally {
                file.attributes().getCustom().remove("set_modification_date");
            }
        } else {
            file.attributes().setModificationDate(System.currentTimeMillis());
        }
    }
}

