/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.io;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.io.Buffer;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.mountainduck.io.BufferOutputStream;
import ch.iterate.mountainduck.io.Marker;
import ch.iterate.mountainduck.io.WriteStrategy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TemporaryWriteStrategy
implements WriteStrategy {
    private static final Logger log = LogManager.getLogger((String)TemporaryWriteStrategy.class.getName());
    private final Buffer buffer;

    public TemporaryWriteStrategy(Buffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public StatusOutputStream write(Path file, Long length, Long offset) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Skip buffered output %s for file %s for write length %d and offset %d", this.buffer, file, length, offset));
        }
        return new BufferOutputStream(this.buffer, offset);
    }

    @Override
    public boolean contains(Marker marker) {
        return true;
    }

    @Override
    public TransferStatus close(Path file) throws BackgroundException {
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TemporaryWriteStrategy{");
        sb.append("buffer=").append(this.buffer);
        sb.append('}');
        return sb.toString();
    }
}

