/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.io;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.SleepPreventer;
import ch.cyberduck.core.SleepPreventerFactory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.io.CloseCallback;
import java.io.Closeable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SleepPreventerCloseCallback
implements CloseCallback {
    private static final Logger log = LogManager.getLogger((String)SleepPreventerCloseCallback.class.getName());
    private final SleepPreventer sleep = SleepPreventerFactory.get();
    private final String lock = this.sleep.lock();

    public SleepPreventerCloseCallback() {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Acquired sleep lock %s", this.lock));
        }
    }

    @Override
    public void closed(Path file, TransferStatus status, Closeable stream, FilesystemCallbacks.Mode mode) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Release sleep lock %s", this.lock));
        }
        this.sleep.release(this.lock);
    }
}

