/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.io;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.fs.FilesystemOperations;
import ch.iterate.mountainduck.io.CloseCallback;
import java.io.Closeable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SessionReleaseCloseCallback
implements CloseCallback {
    private static final Logger log = LogManager.getLogger((String)SessionReleaseCloseCallback.class.getName());
    private final FilesystemOperations<?> fs;
    private final Session<?> session;

    public SessionReleaseCloseCallback(FilesystemOperations<?> fs, Session<?> session) {
        this.fs = fs;
        this.session = session;
    }

    @Override
    public void closed(Path file, TransferStatus status, Closeable stream, FilesystemCallbacks.Mode mode) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Release stream %s", stream));
        }
        this.fs.getPool().release(this.session);
    }
}

