/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.io;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.CachingAttributesFinderFeature;
import ch.cyberduck.core.CachingFindFeature;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledProgressListener;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Bulk;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.DefaultStreamCloser;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.io.StreamCopier;
import ch.cyberduck.core.io.StreamProgress;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferPathFilter;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.symlink.DisabledUploadSymlinkResolver;
import ch.cyberduck.core.transfer.symlink.SymlinkResolver;
import ch.cyberduck.core.transfer.upload.AbstractUploadFilter;
import ch.cyberduck.core.transfer.upload.OverwriteFilter;
import ch.cyberduck.core.transfer.upload.UploadFilterOptions;
import ch.cyberduck.core.worker.Worker;
import ch.iterate.mountainduck.fs.FilesystemCache;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.fs.FilesystemFilenameBlacklist;
import ch.iterate.mountainduck.fs.FilesystemMockLocal;
import ch.iterate.mountainduck.fs.KeepAliveSessionPool;
import ch.iterate.mountainduck.fs.SessionFilesystemOperations;
import ch.iterate.mountainduck.fs.TemporaryFileMarker;
import ch.iterate.mountainduck.fs.buffer.MarkerBuffer;
import ch.iterate.mountainduck.io.BufferOutputStream;
import ch.iterate.mountainduck.io.BulkFeatureCallback;
import ch.iterate.mountainduck.io.CallbackOutputStream;
import ch.iterate.mountainduck.io.CloseCallback;
import ch.iterate.mountainduck.io.CloseCallbackChain;
import ch.iterate.mountainduck.io.Marker;
import ch.iterate.mountainduck.io.MarkerMap;
import ch.iterate.mountainduck.io.MarkerOutputStream;
import ch.iterate.mountainduck.io.PermissionCloseCallback;
import ch.iterate.mountainduck.io.SessionReleaseCloseCallback;
import ch.iterate.mountainduck.io.SleepPreventerCloseCallback;
import ch.iterate.mountainduck.io.TemporaryMarkerCloseCallback;
import ch.iterate.mountainduck.io.TimestampCloseCallback;
import ch.iterate.mountainduck.io.TransferFilterCallback;
import ch.iterate.mountainduck.io.WriteMarker;
import ch.iterate.mountainduck.io.WriteStrategy;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.io.output.ProxyOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SequentialWriteStrategy
implements WriteStrategy {
    private static final Logger log = LogManager.getLogger((String)SequentialWriteStrategy.class.getName());
    private final Preferences preferences = PreferencesFactory.get();
    private final SessionFilesystemOperations<?> fs;
    private final FilesystemCache cache;
    private final FilesystemFilenameBlacklist lockowner;
    private final MarkerMap<StatusOutputStream<TransferStatus>> streams = new MarkerMap();
    private final MarkerBuffer buffer;
    private final ConnectionCallback prompt;

    public SequentialWriteStrategy(SessionFilesystemOperations<?> fs, FilesystemCache cache, MarkerBuffer buffer, ConnectionCallback prompt, FilesystemFilenameBlacklist lockowner) {
        this.fs = fs;
        this.cache = cache;
        this.buffer = buffer;
        this.prompt = prompt;
        this.lockowner = lockowner;
    }

    @Override
    public StatusOutputStream write(final Path file, final Long length, final Long offset) throws BackgroundException {
        final WriteMarker marker = new WriteMarker(file, offset);
        if (this.contains(marker)) {
            StatusOutputStream<TransferStatus> out = this.streams.get(marker);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Return already open output stream %s for file %s with marker %s for write length %d", out, file, marker, length));
            }
            return out;
        }
        if (log.isInfoEnabled()) {
            log.info(String.format("Open output stream for file %s with marker %s for write length %d", file, marker, length));
        }
        return this.fs.getPool().await(new Worker<StatusOutputStream>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public StatusOutputStream run(Session<?> session) throws BackgroundException {
                Write feature;
                FilesystemMockLocal local = new FilesystemMockLocal(SequentialWriteStrategy.this.fs, file, length);
                UploadFilterOptions options = new UploadFilterOptions(SequentialWriteStrategy.this.fs.getHost());
                options.checksum = false;
                if (log.isInfoEnabled()) {
                    log.info(String.format("Apply filter for file %s with options %s", file, options));
                }
                AbstractUploadFilter f = new OverwriteFilter((SymlinkResolver)new DisabledUploadSymlinkResolver(), session, options).withFinder((Find)new CachingFindFeature((Cache)(new TemporaryFileMarker().contains(file) ? PathCache.empty() : SequentialWriteStrategy.this.cache), (Find)session.getFeature(Find.class, (Object)new DefaultFindFeature(session)))).withAttributes((AttributesFinder)new CachingAttributesFinderFeature((Cache)(new TemporaryFileMarker().contains(file) ? PathCache.empty() : SequentialWriteStrategy.this.cache), (AttributesFinder)session.getFeature(AttributesFinder.class, (Object)new DefaultAttributesFinderFeature(session))));
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Use transfer filter %s", f));
                }
                if (null == (feature = (Write)session.getFeature(MultipartWrite.class))) {
                    feature = (Write)session.getFeature(Write.class);
                }
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Obtained writer %s for file %s", feature, file));
                }
                Bulk bulk = (Bulk)session.getFeature(Bulk.class);
                final TransferStatus status = f.prepare(file, (Local)local, new TransferStatus().exists(true), (ProgressListener)new DisabledProgressListener());
                if (-1L == file.attributes().getModificationDate()) {
                    status.setTimestamp(Long.valueOf(System.currentTimeMillis()));
                } else {
                    status.setTimestamp(Long.valueOf(file.attributes().getModificationDate()));
                }
                status.setLockId((Object)SequentialWriteStrategy.this.fs.getLock(file));
                CloseCallbackChain callback = new CloseCallbackChain(new SleepPreventerCloseCallback(), new SessionReleaseCloseCallback(SequentialWriteStrategy.this.fs, session), new TransferFilterCallback((TransferPathFilter)f), new TimestampCloseCallback(SequentialWriteStrategy.this.fs), new PermissionCloseCallback(SequentialWriteStrategy.this.fs), new BulkFeatureCallback(bulk, local, Transfer.Type.upload, SequentialWriteStrategy.this.prompt), new TemporaryMarkerCloseCallback(), new CloseCallback(){

                    @Override
                    public void closed(Path file, TransferStatus status, Closeable stream, FilesystemCallbacks.Mode mode) {
                        log.warn(String.format("Remove stream %s for %s at marker %s after close", stream, file, marker));
                        if (!SequentialWriteStrategy.this.streams.remove(marker)) {
                            log.warn(String.format("No cached stream with marker %s found", marker));
                        }
                    }
                });
                status.setLength(-1L);
                if (offset > 0L) {
                    if (!feature.append((Path)file, (TransferStatus)status).append) {
                        log.warn(String.format("Disable use of append for protocol %s. Read %d bytes from file %s", SequentialWriteStrategy.this.fs.getHost().getProtocol(), offset, file));
                        SequentialWriteStrategy.this.fs.open(file, FilesystemCallbacks.Mode.read, -1L != file.attributes().getSize() ? file.attributes().getSize() : 0L, Application.notfound);
                        try {
                            SequentialWriteStrategy.this.buffer(file, SequentialWriteStrategy.this.fs.read(file, offset, 0L), SequentialWriteStrategy.this.buffer.withLimit(Long.MAX_VALUE));
                        }
                        finally {
                            SequentialWriteStrategy.this.fs.close(file, FilesystemCallbacks.Mode.read, Application.notfound, false);
                        }
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Append with offset %s to %s", offset, file));
                        }
                        status.append(true).withOffset(offset.longValue());
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Determined status %s for file %s", status, file));
                }
                try {
                    Object id = bulk.pre(Transfer.Type.upload, Collections.singletonMap(new TransferItem(file, (Local)local), status), SequentialWriteStrategy.this.prompt);
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Obtained bulk id %s for file %s", id, file));
                    }
                }
                catch (AccessDeniedException e) {
                    log.warn(String.format("Ignore bulk pre transfer failure %s", new Object[]{e}));
                }
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Opening stream from writer %s for file %s", feature, file));
                }
                final StatusOutputStream stream = feature.write(file, status, SequentialWriteStrategy.this.prompt);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Opened stream %s for %s", stream, file));
                }
                if (offset > 0L && !status.isAppend()) {
                    log.warn(String.format("Write to %s from buffer %s", file, SequentialWriteStrategy.this.buffer));
                    SequentialWriteStrategy.this.unbuffer(file, (OutputStream)stream, SequentialWriteStrategy.this.buffer, 0L);
                }
                BufferOutputStream buffered = new BufferOutputStream((OutputStream)new ProxyOutputStream((OutputStream)((Object)new CallbackOutputStream(file, status, new MarkerOutputStream(stream, marker), callback))){

                    protected void handleIOException(IOException e) throws IOException {
                        log.warn(String.format("Remove stream %s at marker %s after failure %s", stream, marker, e));
                        if (!SequentialWriteStrategy.this.streams.remove(marker)) {
                            log.warn(String.format("No cached stream with marker %s found in %s", marker, SequentialWriteStrategy.this.streams));
                        }
                        throw e;
                    }
                }, SequentialWriteStrategy.this.buffer, offset){

                    @Override
                    protected void handleFailure(IOException e) {
                        log.warn(e.getMessage());
                    }
                };
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Cache stream %s for file %s", new Object[]{buffered, file}));
                }
                StatusOutputStream<TransferStatus> wrapper = new StatusOutputStream<TransferStatus>((OutputStream)((Object)buffered)){

                    protected void afterWrite(int n) throws IOException {
                        if (length < (long)SequentialWriteStrategy.this.preferences.getInteger("fs.write.buffer") && SequentialWriteStrategy.this.lockowner.contains(file)) {
                            log.warn(String.format("Flush stream for file %s after writing %d bytes", file, n));
                            this.flush();
                        }
                    }

                    public TransferStatus getStatus() {
                        return status;
                    }
                };
                SequentialWriteStrategy.this.streams.put(marker, wrapper);
                return wrapper;
            }

            public StatusOutputStream initialize() {
                log.warn(String.format("Return null output stream for file %s", file));
                return null;
            }
        }, new KeepAliveSessionPool(this.fs.getPool()));
    }

    @Override
    public boolean contains(Marker marker) {
        if (this.streams.containsKey(marker)) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("No stream for marker %s", marker));
        }
        return false;
    }

    private void unbuffer(Path file, OutputStream out, MarkerBuffer buffer, Long offset) throws BackgroundException {
        if (log.isInfoEnabled()) {
            log.info(String.format("Write to %s from buffer %s at offset %s", file, buffer, offset));
        }
        new StreamCopier(StreamCancelation.noop, StreamProgress.noop).withOffset(offset).transfer(buffer.getInputStream(), (OutputStream)((Object)new CloseFlushDisabledOutputStream(out)));
    }

    private void buffer(Path file, InputStream in, MarkerBuffer buffer) throws BackgroundException {
        if (log.isInfoEnabled()) {
            log.info(String.format("Buffer from input %s", in));
        }
        new StreamCopier(StreamCancelation.noop, StreamProgress.noop).transfer(in, buffer.getOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TransferStatus close(Path file) throws BackgroundException {
        if (file.attributes().getSize() > 0L && this.buffer.getState() == MarkerBuffer.State.open && this.buffer.length() > file.attributes().getSize()) {
            for (Marker marker : this.streams.keySet()) {
                if (marker.current().longValue() != file.attributes().getSize()) continue;
                this.unbuffer(file, (OutputStream)this.streams.get(marker), this.buffer, marker.current());
                break;
            }
        }
        Collection<StatusOutputStream<TransferStatus>> values = this.streams.values();
        Iterator<StatusOutputStream<TransferStatus>> iterator = this.streams.values().iterator();
        if (!iterator.hasNext()) return null;
        StatusOutputStream<TransferStatus> stream = iterator.next();
        if (log.isInfoEnabled()) {
            log.info(String.format("Close stream %s for %s", stream, file));
        }
        try {
            new DefaultStreamCloser().close(stream);
            if (values.remove(stream)) return (TransferStatus)stream.getStatus();
        }
        catch (Throwable throwable) {
            if (values.remove(stream)) throw throwable;
            log.warn(String.format("Stream %s already removed from cache", stream));
            throw throwable;
        }
        log.warn(String.format("Stream %s already removed from cache", stream));
        return (TransferStatus)stream.getStatus();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SequentialWriteStrategy{");
        sb.append("streams=").append(this.streams);
        sb.append('}');
        return sb.toString();
    }

    private static final class CloseFlushDisabledOutputStream
    extends ProxyOutputStream {
        private static final Logger log = LogManager.getLogger((String)CloseFlushDisabledOutputStream.class.getName());
        private final OutputStream proxy;

        public CloseFlushDisabledOutputStream(OutputStream proxy) {
            super(proxy);
            this.proxy = proxy;
        }

        public void flush() {
            log.warn(String.format("Discard flush for %s", this.proxy));
        }

        public void close() throws IOException {
            log.warn(String.format("Discard close for %s", this.proxy));
        }
    }
}

