/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.io;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.fs.FilesystemOperations;
import ch.iterate.mountainduck.fs.FilesystemPermissionWorker;
import ch.iterate.mountainduck.io.CloseCallback;
import java.io.Closeable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PermissionCloseCallback
implements CloseCallback {
    private static final Logger log = LogManager.getLogger((String)PermissionCloseCallback.class.getName());
    private final FilesystemOperations<?> fs;

    public PermissionCloseCallback(FilesystemOperations<?> fs) {
        this.fs = fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closed(Path file, TransferStatus status, Closeable stream, FilesystemCallbacks.Mode mode) throws BackgroundException {
        if (Permission.EMPTY == file.attributes().getPermission()) {
            log.warn(String.format("Skip updating permissions for file %s", file));
            return;
        }
        if (file.attributes().getCustom().containsKey("set_permissions")) {
            try {
                this.fs.getPool().execute(new FilesystemPermissionWorker(file, file.attributes().getPermission()));
            }
            catch (UnsupportedException e) {
                log.warn(String.format("Ignore failure %s", new Object[]{e}));
            }
            finally {
                file.attributes().getCustom().remove("set_permissions");
            }
        }
    }
}

