/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.io;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.CachingAttributesFinderFeature;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Bulk;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.io.DefaultStreamCloser;
import ch.cyberduck.core.io.IOResumeException;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.transfer.AutoTransferConnectionLimiter;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferPathFilter;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.download.DownloadFilterOptions;
import ch.cyberduck.core.transfer.download.OverwriteFilter;
import ch.cyberduck.core.transfer.symlink.DisabledDownloadSymlinkResolver;
import ch.cyberduck.core.transfer.symlink.SymlinkResolver;
import ch.cyberduck.core.worker.Worker;
import ch.iterate.mountainduck.fs.FilesystemCache;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.fs.FilesystemMockLocal;
import ch.iterate.mountainduck.fs.KeepAliveSessionPool;
import ch.iterate.mountainduck.fs.SessionFilesystemOperations;
import ch.iterate.mountainduck.fs.buffer.MarkerBuffer;
import ch.iterate.mountainduck.io.BufferCopyingInputStream;
import ch.iterate.mountainduck.io.BulkFeatureCallback;
import ch.iterate.mountainduck.io.CallbackInputStream;
import ch.iterate.mountainduck.io.CloseCallback;
import ch.iterate.mountainduck.io.CloseCallbackChain;
import ch.iterate.mountainduck.io.EndOfFileCloseInputStream;
import ch.iterate.mountainduck.io.FixedLengthInputStream;
import ch.iterate.mountainduck.io.Marker;
import ch.iterate.mountainduck.io.MarkerInputStream;
import ch.iterate.mountainduck.io.MarkerMap;
import ch.iterate.mountainduck.io.ReadStrategy;
import ch.iterate.mountainduck.io.SessionReleaseCloseCallback;
import ch.iterate.mountainduck.io.SleepPreventerCloseCallback;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OffsetReadStrategy
implements ReadStrategy,
MarkerMap.RemovalListener<Marker, InputStream> {
    private static final Logger log = LogManager.getLogger((String)OffsetReadStrategy.class.getName());
    private final Long threshold = PreferencesFactory.get().getLong("fs.readahead.threshold");
    private final SessionFilesystemOperations<?> fs;
    private final FilesystemCache cache;
    private final MarkerBuffer buffer;
    private final MarkerMap<InputStream> streams;
    private final ConnectionCallback callback;

    public OffsetReadStrategy(SessionFilesystemOperations<?> fs, FilesystemCache cache, MarkerBuffer buffer, ConnectionCallback callback) {
        this.fs = fs;
        this.cache = cache;
        this.buffer = buffer;
        this.callback = callback;
        this.streams = new MarkerMap<InputStream>(new AutoTransferConnectionLimiter().getLimit(fs.getHost()), this);
    }

    @Override
    public InputStream read(final Path file, final Long length, final Long offset) throws BackgroundException {
        final Marker inMarker = new Marker(file, offset);
        if (this.contains(inMarker)) {
            InputStream stream = this.streams.get(inMarker);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Return already open input stream %s for file %s at marker %s", stream, file, inMarker));
            }
            return stream;
        }
        if (log.isInfoEnabled()) {
            log.info(String.format("Open input stream for file %s with marker %s", file, inMarker));
        }
        for (Marker m : this.streams.keySet().toArray(new Marker[this.streams.keySet().size()])) {
            InputStream stream;
            if (null == m || !this.readAhead(m.current(), offset, length) || null == (stream = this.streams.get(m))) continue;
            try {
                long toSkip;
                long skipped;
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Read %d bytes of stream with current position %d into buffer and return it", offset - m.current(), m.current()));
                }
                if ((skipped = OffsetReadStrategy.skip(stream, toSkip = offset - m.current())) < toSkip) {
                    throw new IOResumeException(String.format("Skipped %d bytes of %d only", skipped, offset));
                }
                return stream;
            }
            catch (IOException e) {
                log.warn(String.format("Ignore failure %s reading from already open stream at marker %s", e, m));
                this.streams.remove(m);
                this.close(stream);
            }
        }
        final FilesystemMockLocal local = new FilesystemMockLocal(this.fs, file, length);
        return this.fs.getPool().await(new Worker<InputStream>(){

            public InputStream run(Session<?> session) throws BackgroundException {
                boolean readAhead;
                TransferPathFilter filter = OffsetReadStrategy.this.filter(session, file);
                Read feature = (Read)session.getFeature(Read.class);
                TransferStatus status = filter.prepare(file, local, new TransferStatus().exists(true), (ProgressListener)new DisabledProgressListener());
                status.setLockId((Object)OffsetReadStrategy.this.fs.getLock(file));
                status.withLength(-1L);
                boolean bl = readAhead = OffsetReadStrategy.this.readAhead(0L, offset, length) && OffsetReadStrategy.this.buffer.getLimit() >= offset + length;
                if (!readAhead && offset > 0L && feature.offset(file)) {
                    status.append(true).withOffset(offset.longValue());
                }
                Bulk bulk = (Bulk)session.getFeature(Bulk.class);
                try {
                    Object id = bulk.pre(Transfer.Type.download, Collections.singletonMap(new TransferItem(file, local), status), OffsetReadStrategy.this.callback);
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Obtained bulk id %s for file %s", id, file));
                    }
                }
                catch (AccessDeniedException e) {
                    log.warn(String.format("Ignore bulk pre transfer failure %s", new Object[]{e}));
                }
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Opening stream from reader %s for file %s", feature, file));
                }
                final InputStream stream = feature.read(file, status, OffsetReadStrategy.this.callback);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Opened stream %s for %s", stream, file));
                }
                boolean bufferedSkip = readAhead || offset > 0L && !status.isAppend();
                long size = -1L != file.attributes().getSize() ? file.attributes().getSize() : 0L;
                final Marker outMarker = bufferedSkip ? new Marker(file, 0L) : inMarker;
                CloseCallbackChain callback = new CloseCallbackChain(new SleepPreventerCloseCallback(), new SessionReleaseCloseCallback(OffsetReadStrategy.this.fs, session), new BulkFeatureCallback(bulk, local, Transfer.Type.download, OffsetReadStrategy.this.callback), new CloseCallback(){

                    @Override
                    public void closed(Path file, TransferStatus status, Closeable stream, FilesystemCallbacks.Mode mode) {
                        log.warn(String.format("Remove stream %s for %s at marker %s after close", stream, file, outMarker));
                        if (!OffsetReadStrategy.this.streams.remove(outMarker)) {
                            log.warn(String.format("No cached stream with marker %s found", outMarker));
                        }
                    }
                });
                ProxyInputStream in = new ProxyInputStream((InputStream)((Object)new EndOfFileCloseInputStream((InputStream)((Object)new FixedLengthInputStream((InputStream)((Object)new CallbackInputStream(file, status, (InputStream)((Object)new MarkerInputStream((InputStream)(offset < OffsetReadStrategy.this.buffer.getLimit() ? new BufferCopyingInputStream(stream, OffsetReadStrategy.this.buffer, bufferedSkip ? 0L : offset) : stream), outMarker)), callback)), size))){})){

                    protected void handleIOException(IOException e) throws IOException {
                        log.warn(String.format("Remove stream %s at marker %s after failure %s", stream, outMarker, e));
                        if (!OffsetReadStrategy.this.streams.remove(outMarker)) {
                            log.warn(String.format("No cached stream with marker %s found in %s", outMarker, OffsetReadStrategy.this.streams));
                        }
                        throw e;
                    }
                };
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Cache stream %s for file %s", in, file));
                }
                if (bufferedSkip) {
                    try {
                        long skipped;
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Read %d bytes of stream with current position %d into buffer and return it", offset, 0));
                        }
                        if ((skipped = OffsetReadStrategy.skip((InputStream)in, offset)) < offset) {
                            throw new IOResumeException(String.format("Skipped %d bytes of %d only", skipped, offset));
                        }
                    }
                    catch (IOException e) {
                        throw new DefaultIOExceptionMappingService().map(e);
                    }
                }
                OffsetReadStrategy.this.streams.put(outMarker, in);
                return in;
            }

            public InputStream initialize() {
                log.warn(String.format("Return null input stream for file %s", file));
                return null;
            }
        }, new KeepAliveSessionPool(this.fs.getPool()));
    }

    private boolean readAhead(Long current, Long offset, Long length) {
        long toSkip = offset - current;
        if (toSkip <= 0L) {
            return false;
        }
        return current < offset && toSkip < this.threshold;
    }

    protected TransferPathFilter filter(Session<?> session, Path file) {
        DownloadFilterOptions options = new DownloadFilterOptions(this.fs.getHost());
        options.segments = false;
        if (log.isInfoEnabled()) {
            log.info(String.format("Apply filter for file %s with options %s", file, options));
        }
        return new OverwriteFilter((SymlinkResolver)new DisabledDownloadSymlinkResolver(), session, options).withAttributes((AttributesFinder)new CachingAttributesFinderFeature((Cache)this.cache, (AttributesFinder)session.getFeature(AttributesFinder.class, (Object)new DefaultAttributesFinderFeature(session))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Path file) throws BackgroundException {
        Collection<InputStream> values = this.streams.values();
        for (InputStream stream : values.toArray(new InputStream[values.size()])) {
            if (stream == null) continue;
            if (log.isInfoEnabled()) {
                log.info(String.format("Close stream %s for %s", stream, file));
            }
            try {
                this.close(stream);
                if (values.remove(stream)) continue;
            }
            catch (Throwable throwable) {
                if (!values.remove(stream)) {
                    log.warn(String.format("Stream %s already removed from cache", stream));
                }
                throw throwable;
            }
            log.warn(String.format("Stream %s already removed from cache", stream));
        }
    }

    private boolean contains(Marker marker) {
        for (Marker m : this.streams.keySet()) {
            if (!m.equals(marker)) continue;
            return true;
        }
        if (log.isInfoEnabled()) {
            log.info(String.format("No stream for marker %s", marker));
        }
        return false;
    }

    @Override
    public boolean contains(Marker marker, Long length) {
        if (this.contains(marker)) {
            return true;
        }
        for (Marker m : this.streams.keySet()) {
            if (!this.readAhead(m.current(), marker.current(), length)) continue;
            return true;
        }
        if (log.isInfoEnabled()) {
            log.info(String.format("No stream for marker %s", marker));
        }
        return false;
    }

    private static long skip(InputStream input, long toSkip) throws IOException {
        long remain;
        long n;
        byte[] buffer = new byte[PreferencesFactory.get().getInteger("fs.read.buffer")];
        for (remain = toSkip; remain > 0L && (n = (long)input.read(buffer, 0, (int)Math.min(remain, (long)buffer.length))) >= 0L; remain -= n) {
        }
        return toSkip - remain;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OffsetReadStrategy{");
        sb.append("fs=").append(this.fs);
        sb.append(", buffer=").append(this.buffer);
        sb.append(", streams=").append(this.streams);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void onRemoval(Marker marker, InputStream stream) {
        if (log.isInfoEnabled()) {
            log.info(String.format("Close stream %s with marker %s", stream, marker));
        }
        this.close(stream);
    }

    private void close(InputStream stream) {
        try {
            new DefaultStreamCloser().close(stream);
        }
        catch (BackgroundException e) {
            log.warn(String.format("Ignore failure closing stream %s after removal from cache", stream));
        }
    }
}

