/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.io;

import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.iterate.mountainduck.io.Marker;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MarkerOutputStream
extends StatusOutputStream {
    private static final Logger log = LogManager.getLogger((String)MarkerOutputStream.class.getName());
    private final Marker marker;
    private final StatusOutputStream proxy;

    public MarkerOutputStream(StatusOutputStream proxy, Marker marker) {
        super((OutputStream)proxy);
        this.marker = marker;
        this.proxy = proxy;
    }

    protected void afterWrite(int n) {
        this.marker.increment(n);
    }

    public void close() throws IOException {
        if (log.isInfoEnabled()) {
            log.info(String.format("Close output stream %s", new Object[]{this}));
        }
        this.marker.close();
        super.close();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MarkerOutputStream{");
        sb.append("proxy=").append(this.proxy);
        sb.append(", marker=").append(this.marker);
        sb.append('}');
        return sb.toString();
    }

    public Object getStatus() throws BackgroundException {
        return this.proxy.getStatus();
    }
}

