/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.io;

import ch.cyberduck.core.exception.BackgroundException;
import ch.iterate.mountainduck.io.Marker;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MarkerMap<V> {
    private static final Logger log = LogManager.getLogger((String)MarkerMap.class.getName());
    private final Set<KeyValueTuple<V>> internal = new TreeSet<KeyValueTuple<V>>();
    private final int size;
    private final RemovalListener<Marker, V> listener;

    public MarkerMap() {
        this(Integer.MAX_VALUE, (key, value) -> {});
    }

    public MarkerMap(int size, RemovalListener<Marker, V> listener) {
        this.size = size;
        this.listener = listener;
    }

    public V get(Marker key) {
        for (KeyValueTuple<V> t : this.internal) {
            if (!t.key.equals(key)) continue;
            return t.value;
        }
        return null;
    }

    public boolean remove(Marker key) {
        return this.internal.remove(new KeyValueTuple<Object>(key, null));
    }

    public Set<Marker> keySet() {
        HashSet<Marker> values = new HashSet<Marker>();
        for (KeyValueTuple<V> t : this.internal) {
            values.add(t.key);
        }
        return values;
    }

    public boolean containsKey(Marker key) {
        return this.get(key) != null;
    }

    public Collection<V> values() {
        HashSet values = new HashSet();
        for (KeyValueTuple<V> t : this.internal) {
            values.add(t.value);
        }
        return values;
    }

    public void put(Marker key, V value) throws BackgroundException {
        if (this.internal.size() >= this.size) {
            log.warn(String.format("Limit %d reached", this.size));
            Optional<KeyValueTuple> remove = this.internal.stream().min(Comparator.comparing(o -> o.key));
            if (remove.isPresent()) {
                Marker marker = remove.get().key;
                log.warn(String.format("Remove %s with marker %s", remove.get().value, marker));
                this.internal.remove(remove.get());
                this.listener.onRemoval(marker, remove.get().value);
            }
        }
        this.internal.add(new KeyValueTuple<V>(key, value));
    }

    public void clear() {
        this.internal.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MarkerMap{");
        sb.append("internal=").append(this.internal);
        sb.append('}');
        return sb.toString();
    }

    public static interface RemovalListener<K, V> {
        public void onRemoval(K var1, V var2);
    }

    private static final class KeyValueTuple<V>
    implements Comparable<KeyValueTuple<V>> {
        final Marker key;
        final V value;

        public KeyValueTuple(Marker key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int compareTo(KeyValueTuple<V> o) {
            return this.key.compareTo(o.key);
        }
    }
}

