/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.io;

import ch.iterate.mountainduck.io.Marker;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.http.ConnectionClosedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MarkerInputStream
extends CountingInputStream {
    private static final Logger log = LogManager.getLogger((String)MarkerInputStream.class.getName());
    private final Marker marker;

    public MarkerInputStream(InputStream proxy, Marker marker) {
        super(proxy);
        this.marker = marker;
    }

    protected void afterRead(int n) {
        super.afterRead(n);
        if (n != -1) {
            this.marker.increment(n);
        }
    }

    public void close() throws IOException {
        if (log.isInfoEnabled()) {
            log.info(String.format("Close input stream %s", new Object[]{this}));
        }
        this.marker.close();
        super.close();
    }

    protected void handleIOException(IOException e) throws IOException {
        if (e instanceof ConnectionClosedException) {
            log.warn(String.format("Ignore failure %s", e));
            return;
        }
        super.handleIOException(e);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MarkerInputStream{");
        sb.append("marker=").append(this.marker);
        sb.append('}');
        return sb.toString();
    }
}

