/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.io;

import ch.cyberduck.core.Path;
import java.util.Objects;

public class Marker
implements Comparable<Marker> {
    private final Path file;
    private Long offset;

    public Marker(Path file, Long offset) {
        this.file = file;
        this.offset = offset;
    }

    public Long increment(int len) {
        this.offset = this.offset + (long)len;
        return this.offset;
    }

    public void close() {
    }

    public Long current() {
        return this.offset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Marker)) {
            return false;
        }
        Marker marker1 = (Marker)o;
        return Objects.equals(this.file, marker1.file) && Objects.equals(this.offset, marker1.offset);
    }

    public int hashCode() {
        return Objects.hash(this.file, this.offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Marker{");
        sb.append("path=").append(this.file);
        sb.append(", marker=").append(this.offset);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int compareTo(Marker that) {
        if (this.file.getAbsolute().compareTo(that.file.getAbsolute()) < 0) {
            return -1;
        }
        if (this.file.getAbsolute().compareTo(that.file.getAbsolute()) > 0) {
            return 1;
        }
        if (this.offset.compareTo(that.offset) < 0) {
            return -1;
        }
        if (this.offset.compareTo(that.offset) > 0) {
            return 1;
        }
        return 0;
    }
}

