/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.io;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FixedLengthOutputStream
extends CountingOutputStream {
    private static final Logger log = LogManager.getLogger((String)FixedLengthOutputStream.class.getName());
    private final Long threshold;
    private final OutputStream proxy;

    public FixedLengthOutputStream(OutputStream proxy, Long threshold) {
        super(proxy);
        this.proxy = proxy;
        this.threshold = threshold;
    }

    protected void afterWrite(int n) throws IOException {
        long count = this.getByteCount();
        if (count == this.threshold) {
            if (log.isInfoEnabled()) {
                log.info(String.format("Auto close output stream %s after %d bytes sent", new Object[]{this, count}));
            }
            this.flush();
            try {
                this.close();
            }
            catch (IOException e) {
                log.warn(String.format("Failure closing stream without error at threshold %d. %s", this.threshold, e.getMessage()));
            }
        }
        super.afterWrite(n);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FixedLengthOutputStream{");
        sb.append("proxy=").append(this.proxy);
        sb.append(", threshold=").append(this.threshold);
        sb.append('}');
        return sb.toString();
    }
}

