/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FixedLengthInputStream
extends ProxyInputStream {
    private static final Logger log = LogManager.getLogger((String)FixedLengthInputStream.class.getName());
    private final InputStream proxy;
    private final Long threshold;
    private long count;
    private boolean eof = false;

    public FixedLengthInputStream(InputStream proxy, Long threshold) {
        super(proxy);
        this.proxy = proxy;
        this.threshold = threshold;
    }

    public long skip(long length) throws IOException {
        long skip = super.skip(length);
        this.count += skip;
        return skip;
    }

    public int read() throws IOException {
        if (this.eof) {
            log.debug(String.format("Return EOF for auto closed stream %s", new Object[]{this}));
            return -1;
        }
        return super.read();
    }

    public int read(byte[] bts) throws IOException {
        if (this.eof) {
            log.debug(String.format("Return EOF for auto closed stream %s", new Object[]{this}));
            return -1;
        }
        return super.read(bts);
    }

    public int read(byte[] bts, int off, int len) throws IOException {
        if (this.eof) {
            log.debug(String.format("Return EOF for auto closed stream %s", new Object[]{this}));
            return -1;
        }
        return super.read(bts, off, len);
    }

    protected void afterRead(int n) {
        if (n != -1) {
            this.count += (long)n;
        }
        if (this.count == this.threshold) {
            if (log.isInfoEnabled()) {
                log.info(String.format("Auto close input stream %s after %d bytes read", new Object[]{this, this.count}));
            }
            this.eof = true;
            try {
                this.close();
            }
            catch (IOException e) {
                log.warn(String.format("Failure closing stream without error at threshold %d. %s", this.threshold, e.getMessage()));
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FixedLengthInputStream{");
        sb.append("threshold=").append(this.threshold);
        sb.append(", count=").append(this.count);
        sb.append(", proxy=").append(this.proxy);
        sb.append(", eof=").append(this.eof);
        sb.append('}');
        return sb.toString();
    }
}

