/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EndOfFileCloseInputStream
extends ProxyInputStream {
    private static final Logger log = LogManager.getLogger((String)EndOfFileCloseInputStream.class.getName());
    private final InputStream proxy;
    private boolean eof = false;

    public EndOfFileCloseInputStream(InputStream proxy) {
        super(proxy);
        this.proxy = proxy;
    }

    public int read() throws IOException {
        if (this.eof) {
            log.warn(String.format("Return EOF for auto closed stream %s", new Object[]{this}));
            return -1;
        }
        return super.read();
    }

    public int read(byte[] bts) throws IOException {
        if (this.eof) {
            log.warn(String.format("Return EOF for auto closed stream %s", new Object[]{this}));
            return -1;
        }
        return super.read(bts);
    }

    public int read(byte[] bts, int off, int len) throws IOException {
        if (this.eof) {
            log.warn(String.format("Return EOF for auto closed stream %s", new Object[]{this}));
            return -1;
        }
        return super.read(bts, off, len);
    }

    protected void afterRead(int n) throws IOException {
        if (n == -1) {
            if (log.isInfoEnabled()) {
                log.info(String.format("Auto close input stream %s with EOF after read", new Object[]{this}));
            }
            this.eof = true;
            this.close();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EndOfFileCloseInputStream{");
        sb.append(", proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

