/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.io;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.io.StreamCopier;
import ch.cyberduck.core.io.StreamProgress;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.mountainduck.fs.FilesystemCache;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.fs.FilesystemFilenameBlacklist;
import ch.iterate.mountainduck.fs.SessionFilesystemOperations;
import ch.iterate.mountainduck.fs.TemporaryFileMarker;
import ch.iterate.mountainduck.fs.buffer.MarkerBuffer;
import ch.iterate.mountainduck.io.BufferOutputStream;
import ch.iterate.mountainduck.io.BufferedWriteStrategy;
import ch.iterate.mountainduck.io.Marker;
import ch.iterate.mountainduck.io.MarkerOutputStream;
import ch.iterate.mountainduck.io.OffsetReadStrategy;
import ch.iterate.mountainduck.io.OffsetWriteStrategy;
import ch.iterate.mountainduck.io.TemporaryWriteStrategy;
import ch.iterate.mountainduck.io.TruncateWriteStrategy;
import ch.iterate.mountainduck.io.WriteMarker;
import ch.iterate.mountainduck.io.WriteStrategy;
import ch.iterate.mountainduck.service.DiskUsageService;
import ch.iterate.mountainduck.service.DiskUsageServiceFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DelegatingWriteStrategy
implements WriteStrategy {
    private static final Logger log = LogManager.getLogger((String)DelegatingWriteStrategy.class.getName());
    private final AtomicBoolean open = new AtomicBoolean();
    private final SessionFilesystemOperations<?> fs;
    private final FilesystemCache cache;
    private final FilesystemCallbacks.Mode flags;
    private final MarkerBuffer buffer;
    private final ConnectionCallback callback;
    private final FilesystemFilenameBlacklist temporary;
    private final FilesystemFilenameBlacklist lockowner;
    private WriteStrategy delegate;

    public DelegatingWriteStrategy(SessionFilesystemOperations<?> fs, FilesystemCache cache, FilesystemCallbacks.Mode flags, MarkerBuffer buffer, WriteStrategy delegate, ConnectionCallback callback, FilesystemFilenameBlacklist blacklist) {
        this(fs, cache, flags, buffer, callback, blacklist, FilesystemFilenameBlacklist.disabled);
        this.delegate = delegate;
        this.open.set(true);
    }

    public DelegatingWriteStrategy(SessionFilesystemOperations<?> fs, FilesystemCache cache, FilesystemCallbacks.Mode flags, MarkerBuffer buffer, ConnectionCallback callback, FilesystemFilenameBlacklist temporary, FilesystemFilenameBlacklist lockowner) {
        this.fs = fs;
        this.cache = cache;
        this.flags = flags;
        this.buffer = buffer;
        this.callback = callback;
        this.temporary = temporary;
        this.lockowner = lockowner;
    }

    @Override
    public StatusOutputStream write(Path file, Long length, Long offset) throws BackgroundException {
        if (log.isTraceEnabled()) {
            log.trace(String.format("Write to %s with length %d and offset %d", file, length, offset));
        }
        if (this.open.get()) {
            WriteMarker marker = new WriteMarker(file, offset);
            if (!this.delegate.contains(marker) && file.attributes().getSize() != offset.longValue()) {
                log.warn(String.format("Switch write strategy %s for %s to buffered write at marker %s and buffer length %s", this.delegate, file, marker, this.buffer.length()));
                log.warn(String.format("Close stale output stream %s for file %s", this.delegate, file));
                this.close(file);
                if (file.attributes().getSize() != this.buffer.length().longValue()) {
                    log.warn(String.format("Close buffer %s with invalid length for file %s", this.buffer, file));
                    this.buffer.close();
                }
                this.delegate = this.newBufferedWriteStrategy(file, this.buffer);
            }
        } else if (this.temporary.contains(file)) {
            if (log.isInfoEnabled()) {
                log.info(String.format("Write temporary file %s to buffer %s", file, this.buffer));
            }
            this.delegate = this.newTemporaryWriteStrategy(file, this.buffer);
        } else {
            switch (this.flags) {
                case write: {
                    if (file.attributes().getSize() == offset.longValue()) {
                        this.delegate = this.newOffsetWriteStrategy(file, this.buffer);
                        break;
                    }
                    this.delegate = this.newBufferedWriteStrategy(file, this.buffer);
                    break;
                }
                case write_truncate: {
                    this.delegate = 0L == offset ? this.newTruncateWriteStrategy(file, this.buffer) : (file.attributes().getSize() == offset.longValue() ? this.newOffsetWriteStrategy(file, this.buffer) : this.newBufferedWriteStrategy(file, this.buffer));
                }
            }
        }
        this.open.set(true);
        try {
            return this.delegate.write(file, length, offset);
        }
        catch (WriteStrategy.AppendUnsupportedException e) {
            log.warn(String.format("Switch to buffered writer for %s. %s", file, e.getMessage()));
            this.close(file);
            this.delegate = this.newBufferedWriteStrategy(file, this.buffer);
            this.open.set(true);
            return this.delegate.write(file, length, offset);
        }
    }

    protected WriteStrategy newTemporaryWriteStrategy(Path file, MarkerBuffer buffer) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Open local temporary writer for file %s", file));
        }
        try {
            DiskUsageService diskUsageService = DiskUsageServiceFactory.get();
            return new TemporaryWriteStrategy(buffer.withLimit(diskUsageService.find((Local)LocalFactory.get((String)PreferencesFactory.get().getProperty((String)"tmp.dir"))).available));
        }
        catch (LocalAccessDeniedException e) {
            return new TemporaryWriteStrategy(buffer.withLimit(Long.MAX_VALUE));
        }
    }

    protected WriteStrategy newBufferedWriteStrategy(Path file, MarkerBuffer buffer) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Open buffered writer for file %s", file));
        }
        try {
            DiskUsageService diskUsageService = DiskUsageServiceFactory.get();
            buffer.withLimit(diskUsageService.find((Local)LocalFactory.get((String)PreferencesFactory.get().getProperty((String)"tmp.dir"))).available);
        }
        catch (LocalAccessDeniedException e) {
            buffer.withLimit(Long.MAX_VALUE);
        }
        BufferedWriteStrategy buffered = new BufferedWriteStrategy(this.fs, this.cache, buffer, this.callback);
        if (!buffer.isComplete() && !new TemporaryFileMarker().contains(file)) {
            long length;
            long l = length = -1L != file.attributes().getSize() ? file.attributes().getSize() : 0L;
            if (length > 0L) {
                OffsetReadStrategy reader = new OffsetReadStrategy(this.fs, this.cache, buffer, this.callback);
                InputStream in = reader.read(file, length, 0L);
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Buffer from remote stream %s for file %s", in, file));
                }
                TransferStatus status = new TransferStatus();
                status.setLockId((Object)this.fs.getLock(file));
                WriteMarker marker = new WriteMarker(file, 0L);
                new StreamCopier((StreamCancelation)status, (StreamProgress)status).transfer(in, (OutputStream)((Object)new MarkerOutputStream((StatusOutputStream)new BufferOutputStream(buffer, 0L), marker)));
                if (log.isInfoEnabled()) {
                    log.info(String.format("Buffered %d bytes from remote stream %s for file %s", status.getOffset(), in, file));
                }
                reader.close(file);
            }
        }
        return buffered;
    }

    protected WriteStrategy newOffsetWriteStrategy(Path file, MarkerBuffer buffer) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Open offset writer for file %s", file));
        }
        return new OffsetWriteStrategy(this.fs, this.cache, buffer, this.callback, this.lockowner);
    }

    protected WriteStrategy newTruncateWriteStrategy(Path file, MarkerBuffer buffer) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Open sequential writer for file %s", file));
        }
        return new TruncateWriteStrategy(this.fs, this.cache, buffer, this.callback, this.lockowner);
    }

    @Override
    public TransferStatus close(Path file) throws BackgroundException {
        if (this.open.get()) {
            this.open.set(false);
            TransferStatus reply = this.delegate.close(file);
            if (reply != null) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Swap cache for %s", file));
                }
                this.cache.swap(file, file.withAttributes(WriteStrategy.toAttributes(file, reply)));
            }
            return reply;
        }
        return null;
    }

    @Override
    public boolean contains(Marker marker) {
        if (this.open.get()) {
            return this.delegate.contains(marker);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DelegatingWriteStrategy{");
        sb.append("open=").append(this.open);
        sb.append(", flags=").append((Object)this.flags);
        sb.append(", delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

