/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.io;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.local.Application;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.mountainduck.exception.InvalidOffsetException;
import ch.iterate.mountainduck.fs.FilesystemBuffers;
import ch.iterate.mountainduck.fs.FilesystemCache;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.fs.SessionFilesystemOperations;
import ch.iterate.mountainduck.fs.buffer.MarkerBuffer;
import ch.iterate.mountainduck.io.BufferReadStrategy;
import ch.iterate.mountainduck.io.Marker;
import ch.iterate.mountainduck.io.OffsetReadStrategy;
import ch.iterate.mountainduck.io.ReadStrategy;
import ch.iterate.mountainduck.io.WriteStrategy;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DelegatingReadStrategy
implements ReadStrategy {
    private static final Logger log = LogManager.getLogger((String)DelegatingReadStrategy.class.getName());
    private final AtomicBoolean open = new AtomicBoolean();
    private final SessionFilesystemOperations<?> fs;
    private final FilesystemBuffers buffers;
    private final FilesystemCache cache;
    private final ConnectionCallback callback;
    private ReadStrategy delegate;

    public DelegatingReadStrategy(SessionFilesystemOperations<?> fs, FilesystemBuffers buffers, FilesystemCache cache, ConnectionCallback callback) {
        this.fs = fs;
        this.buffers = buffers;
        this.cache = cache;
        this.callback = callback;
    }

    @Override
    public InputStream read(Path file, Long length, Long offset) throws BackgroundException {
        if (log.isTraceEnabled()) {
            log.trace(String.format("Read from %s with length %d and offset %d", file, length, offset));
        }
        MarkerBuffer buffer = this.buffers.get(file);
        switch (buffer.getState()) {
            case open: {
                BufferReadStrategy buffered = new BufferReadStrategy(buffer);
                if (buffered.contains(new Marker(file, offset), length)) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Read from buffer %s for file %s at offset %d", buffered, file, offset));
                    }
                    return buffered.read(file, length, offset);
                }
                log.warn(String.format("Buffer %s does not contain range with offset %s and length %s for file %s", buffer, offset, length, file));
                if (file.attributes().getSize() == 0L && buffer.isEmpty()) {
                    throw new InvalidOffsetException(String.format("Invalid offset %d for file size %s", offset, file.attributes().getSize()));
                }
                if (!this.fs.contains(file, FilesystemCallbacks.Mode.write)) break;
                log.warn(String.format("Close pending writer for file %s before opening read stream", file));
                TransferStatus reply = this.fs.close(file, FilesystemCallbacks.Mode.write, Application.notfound, false);
                this.cache.swap(file, file.withAttributes(WriteStrategy.toAttributes(file, reply)));
                break;
            }
            case closed: {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Buffer %s closed for file %s", buffer, file));
                }
                if (!this.fs.contains(file, FilesystemCallbacks.Mode.write)) break;
                log.warn(String.format("Close pending writer for file %s before opening read stream", file));
                TransferStatus reply = this.fs.close(file, FilesystemCallbacks.Mode.write, Application.notfound, false);
                this.cache.swap(file, file.withAttributes(WriteStrategy.toAttributes(file, reply)));
            }
        }
        if (this.open.get() && buffer.getLimit() < file.attributes().getSize()) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Truncate buffer %s to known remote file size %d", buffer, file.attributes().getSize()));
            }
            buffer.truncate(file.attributes().getSize());
        }
        if (!this.open.get()) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Truncate buffer %s to known remote file size %d", buffer, file.attributes().getSize()));
            }
            buffer.truncate(file.attributes().getSize());
            if (log.isDebugEnabled()) {
                log.debug(String.format("Open reader for file %s at offset %s", file, offset));
            }
            this.delegate = new OffsetReadStrategy(this.fs, this.cache, buffer, this.callback);
            this.open.set(true);
        }
        return this.delegate.read(file, length, offset);
    }

    @Override
    public void close(Path file) throws BackgroundException {
        if (this.open.get()) {
            this.open.set(false);
            this.delegate.close(file);
        }
    }

    @Override
    public boolean contains(Marker marker, Long length) {
        if (this.open.get()) {
            return this.delegate.contains(marker, length);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DelegatingReadStrategy{");
        sb.append("delegate=").append(this.delegate);
        sb.append(", open=").append(this.open);
        sb.append('}');
        return sb.toString();
    }
}

