/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.io;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.io.CloseCallback;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CloseCallbackChain
implements CloseCallback {
    private final List<CloseCallback> chain;

    public CloseCallbackChain(CloseCallback ... chain) {
        this.chain = new ArrayList<CloseCallback>(Arrays.asList(chain));
    }

    @Override
    public void closed(Path file, TransferStatus status, Closeable stream, FilesystemCallbacks.Mode mode) throws BackgroundException {
        for (CloseCallback proxy : this.chain) {
            proxy.closed(file, status, stream, mode);
        }
    }

    public void add(CloseCallback callback) {
        this.chain.add(callback);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CloseCallbackChain{");
        sb.append("chain=").append(this.chain);
        sb.append('}');
        return sb.toString();
    }
}

