/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.io;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.io.CloseCallback;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.output.ProxyOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CallbackOutputStream
extends ProxyOutputStream {
    private static final Logger log = LogManager.getLogger((String)CallbackOutputStream.class.getName());
    private final CloseCallback callback;
    private final AtomicBoolean close = new AtomicBoolean();
    private final Path file;
    private final TransferStatus status;
    private final StatusOutputStream proxy;

    public CallbackOutputStream(Path file, TransferStatus status, StatusOutputStream proxy, CloseCallback callback) {
        super((OutputStream)proxy);
        this.file = file;
        this.status = status;
        this.proxy = proxy;
        this.callback = callback;
    }

    public void close() throws IOException {
        if (this.close.get()) {
            log.warn(String.format("Skip double close of stream %s", new Object[]{this}));
            return;
        }
        try {
            this.flush();
            super.close();
        }
        finally {
            try {
                this.callback.closed(this.file, this.status.complete(), (Closeable)((Object)this), FilesystemCallbacks.Mode.write);
            }
            catch (BackgroundException e) {
                this.handleIOException(new IOException(e));
            }
            this.close.set(true);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SessionProxyOutputStream{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

