/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.io;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.io.CloseCallback;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CallbackInputStream
extends ProxyInputStream {
    private static final Logger log = LogManager.getLogger((String)CallbackInputStream.class.getName());
    private final CloseCallback callback;
    private final AtomicBoolean close = new AtomicBoolean();
    private final Path file;
    private final TransferStatus status;
    private final InputStream proxy;

    public CallbackInputStream(Path file, TransferStatus status, InputStream proxy, CloseCallback callback) {
        super(proxy);
        this.file = file;
        this.status = status;
        this.proxy = proxy;
        this.callback = callback;
    }

    public void close() throws IOException {
        if (this.close.get()) {
            log.debug(String.format("Skip double close of stream %s", new Object[]{this}));
            return;
        }
        try {
            super.close();
        }
        catch (Throwable throwable) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Notify %s", this.callback));
                }
                this.callback.closed(this.file, this.status, (Closeable)((Object)this), FilesystemCallbacks.Mode.read);
            }
            catch (BackgroundException e) {
                this.handleIOException(new IOException(e));
            }
            this.close.set(true);
            throw throwable;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Notify %s", this.callback));
            }
            this.callback.closed(this.file, this.status, (Closeable)((Object)this), FilesystemCallbacks.Mode.read);
        }
        catch (BackgroundException e) {
            this.handleIOException(new IOException(e));
        }
        this.close.set(true);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SessionProxyInputStream{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

