/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.io;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.CachingAttributesFinderFeature;
import ch.cyberduck.core.CachingFindFeature;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledProgressListener;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Bulk;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.io.StreamCopier;
import ch.cyberduck.core.io.StreamProgress;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.TransferPathFilter;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.symlink.DisabledUploadSymlinkResolver;
import ch.cyberduck.core.transfer.symlink.SymlinkResolver;
import ch.cyberduck.core.transfer.upload.AbstractUploadFilter;
import ch.cyberduck.core.transfer.upload.OverwriteFilter;
import ch.cyberduck.core.transfer.upload.UploadFilterOptions;
import ch.cyberduck.core.worker.Worker;
import ch.iterate.mountainduck.fs.FilesystemCache;
import ch.iterate.mountainduck.fs.FilesystemMockLocal;
import ch.iterate.mountainduck.fs.FilesystemOperations;
import ch.iterate.mountainduck.fs.TemporaryFileMarker;
import ch.iterate.mountainduck.fs.buffer.MarkerBuffer;
import ch.iterate.mountainduck.io.BufferCloseCallback;
import ch.iterate.mountainduck.io.BulkFeatureCallback;
import ch.iterate.mountainduck.io.CallbackOutputStream;
import ch.iterate.mountainduck.io.CloseCallbackChain;
import ch.iterate.mountainduck.io.MarkerOutputStream;
import ch.iterate.mountainduck.io.PermissionCloseCallback;
import ch.iterate.mountainduck.io.SessionReleaseCloseCallback;
import ch.iterate.mountainduck.io.SleepPreventerCloseCallback;
import ch.iterate.mountainduck.io.TemporaryMarkerCloseCallback;
import ch.iterate.mountainduck.io.TemporaryWriteStrategy;
import ch.iterate.mountainduck.io.TimestampCloseCallback;
import ch.iterate.mountainduck.io.TransferFilterCallback;
import ch.iterate.mountainduck.io.WriteMarker;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BufferedWriteStrategy
extends TemporaryWriteStrategy {
    private static final Logger log = LogManager.getLogger((String)BufferedWriteStrategy.class.getName());
    private final FilesystemOperations<?> fs;
    private final FilesystemCache cache;
    private final MarkerBuffer buffer;
    private final ConnectionCallback callback;

    public BufferedWriteStrategy(FilesystemOperations<?> fs, FilesystemCache cache, MarkerBuffer buffer, ConnectionCallback callback) {
        super(buffer);
        this.fs = fs;
        this.cache = cache;
        this.buffer = buffer;
        this.callback = callback;
    }

    @Override
    public TransferStatus close(final Path file) throws BackgroundException {
        return this.fs.getPool().await(new Worker<TransferStatus>(){

            public TransferStatus run(Session<?> session) throws BackgroundException {
                try {
                    Write feature;
                    FilesystemMockLocal local = new FilesystemMockLocal(BufferedWriteStrategy.this.fs, file, BufferedWriteStrategy.this.buffer.length());
                    UploadFilterOptions options = new UploadFilterOptions(BufferedWriteStrategy.this.fs.getHost());
                    options.checksum = false;
                    AbstractUploadFilter f = new OverwriteFilter((SymlinkResolver)new DisabledUploadSymlinkResolver(), session, options).withFinder((Find)new CachingFindFeature((Cache)(new TemporaryFileMarker().contains(file) ? PathCache.empty() : BufferedWriteStrategy.this.cache), (Find)session.getFeature(Find.class, (Object)new DefaultFindFeature(session)))).withAttributes((AttributesFinder)new CachingAttributesFinderFeature((Cache)(new TemporaryFileMarker().contains(file) ? PathCache.empty() : BufferedWriteStrategy.this.cache), (AttributesFinder)session.getFeature(AttributesFinder.class, (Object)new DefaultAttributesFinderFeature(session))));
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Use transfer filter %s", f));
                    }
                    if (null == (feature = (Write)session.getFeature(MultipartWrite.class))) {
                        feature = (Write)session.getFeature(Write.class);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Obtained writer %s for file %s", feature, file));
                    }
                    TransferStatus status = f.prepare(file, (Local)local, new TransferStatus().exists(true), (ProgressListener)new DisabledProgressListener());
                    if (-1L == file.attributes().getModificationDate()) {
                        status.setTimestamp(Long.valueOf(System.currentTimeMillis()));
                    } else {
                        status.setTimestamp(Long.valueOf(file.attributes().getModificationDate()));
                    }
                    status.setLockId((Object)BufferedWriteStrategy.this.fs.getLock(file));
                    status.append(false);
                    status.withLength(BufferedWriteStrategy.this.buffer.length().longValue());
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Determined status %s for file %s", status, file));
                    }
                    Bulk bulk = (Bulk)session.getFeature(Bulk.class);
                    try {
                        Object id = bulk.pre(Transfer.Type.upload, Collections.singletonMap(new TransferItem(file, (Local)local), status), BufferedWriteStrategy.this.callback);
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Obtained bulk id %s for file %s", id, file));
                        }
                    }
                    catch (AccessDeniedException e) {
                        log.warn(String.format("Ignore bulk pre transfer failure %s", new Object[]{e}));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Opening stream from writer %s for file %s", feature, file));
                    }
                    StatusOutputStream stream = feature.write(file, status, BufferedWriteStrategy.this.callback);
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Opened stream %s for %s", stream, file));
                    }
                    CloseCallbackChain callback = new CloseCallbackChain(new SleepPreventerCloseCallback(), new SessionReleaseCloseCallback(BufferedWriteStrategy.this.fs, session), new TransferFilterCallback((TransferPathFilter)f), new TimestampCloseCallback(BufferedWriteStrategy.this.fs), new PermissionCloseCallback(BufferedWriteStrategy.this.fs), new BulkFeatureCallback(bulk, local, Transfer.Type.upload, BufferedWriteStrategy.this.callback), new BufferCloseCallback(BufferedWriteStrategy.this.buffer), new TemporaryMarkerCloseCallback());
                    WriteMarker marker = new WriteMarker(file, 0L);
                    CallbackOutputStream proxy = new CallbackOutputStream(file, status, new MarkerOutputStream(stream, marker), callback);
                    new StreamCopier((StreamCancelation)status, (StreamProgress)status).transfer(BufferedWriteStrategy.this.buffer.getInputStream(), (OutputStream)((Object)proxy));
                    return status;
                }
                catch (BackgroundException e) {
                    log.warn(String.format("Failure %s uploading %s from buffer %s", new Object[]{e, file, BufferedWriteStrategy.this.buffer}));
                    BufferedWriteStrategy.this.fs.delete(file);
                    throw e;
                }
            }
        });
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("BufferedWriteStrategy{");
        sb.append("buffer=").append(this.buffer);
        sb.append('}');
        return sb.toString();
    }
}

