/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.io;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.iterate.mountainduck.exception.InvalidOffsetException;
import ch.iterate.mountainduck.fs.buffer.MarkerBuffer;
import ch.iterate.mountainduck.io.Marker;
import ch.iterate.mountainduck.io.ReadStrategy;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.NullInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BufferReadStrategy
implements ReadStrategy {
    private static final Logger log = LogManager.getLogger((String)BufferReadStrategy.class.getName());
    private final MarkerBuffer buffer;

    public BufferReadStrategy(MarkerBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public InputStream read(Path file, Long length, Long offset) throws BackgroundException {
        if (length > Integer.MAX_VALUE) {
            throw new InvalidOffsetException(String.format("Invalid length %d parameter out of integer range for buffer %s", length, this.buffer));
        }
        byte[] b = new byte[length.intValue()];
        try {
            int read = this.buffer.read(b, offset);
            if (-1 == read) {
                return new NullInputStream(0L);
            }
            byte[] copy = new byte[read];
            System.arraycopy(b, 0, copy, 0, read);
            return new ByteArrayInputStream(copy);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    @Override
    public void close(Path file) throws BackgroundException {
    }

    @Override
    public boolean contains(Marker marker, Long length) {
        switch (this.buffer.getState()) {
            case open: {
                if (marker.current() + length > this.buffer.length()) {
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Invalid offset %d and length %d to read from buffer %s", marker.current(), length, this.buffer));
                    }
                    return false;
                }
                return this.buffer.contains(marker, length);
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BufferReadStrategy{");
        sb.append("buffer=").append(this.buffer);
        sb.append('}');
        return sb.toString();
    }
}

