/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.io;

import ch.cyberduck.core.io.Buffer;
import ch.cyberduck.core.io.VoidStatusOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BufferOutputStream
extends VoidStatusOutputStream {
    private static final Logger log = LogManager.getLogger((String)BufferOutputStream.class.getName());
    private final Buffer buffer;
    private Long offset;

    public BufferOutputStream(Buffer buffer) {
        this((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM, buffer, 0L);
    }

    public BufferOutputStream(Buffer buffer, Long offset) {
        this((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM, buffer, offset);
    }

    public BufferOutputStream(OutputStream proxy, Buffer buffer, Long offset) {
        super(proxy);
        this.buffer = buffer;
        this.offset = offset;
    }

    public void write(byte[] content) throws IOException {
        this.write(content, 0, content.length);
    }

    public void write(byte[] content, int off, int len) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Buffer %d bytes at offset %d", len, this.offset));
        }
        byte[] chunk = new byte[len];
        System.arraycopy(content, off, chunk, 0, len);
        if (this.buffer.write(chunk, this.offset) != len) {
            log.warn(String.format("Failure buffering chunk of size %d", len));
            this.handleFailure(new IOException(String.format("Failure buffering chunk of size %d", len)));
        }
        super.write(content, off, len);
    }

    protected void afterWrite(int len) {
        this.offset = this.offset + (long)len;
    }

    protected void handleFailure(IOException e) throws IOException {
        throw e;
    }
}

