/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.io;

import ch.cyberduck.core.io.Buffer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BufferCopyingInputStream
extends ProxyInputStream {
    private static final Logger log = LogManager.getLogger((String)BufferCopyingInputStream.class.getName());
    private final Buffer buffer;
    private Long offset;

    public BufferCopyingInputStream(InputStream proxy, Buffer buffer, Long offset) {
        super(proxy);
        this.buffer = buffer;
        this.offset = offset;
    }

    public int read() throws IOException {
        return this.read(new byte[1], 0, 1);
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] content, int off, int len) throws IOException {
        int read = super.read(content, off, len);
        if (read == -1) {
            return -1;
        }
        if (this.buffer.write(Arrays.copyOfRange(content, off, off + read), this.offset) != read) {
            this.handleFailure(new IOException(String.format("Failure buffering chunk of size %d to %s", len, this.buffer)));
        }
        this.offset = this.offset + (long)read;
        return read;
    }

    protected void handleFailure(IOException e) throws IOException {
        log.warn(e.getMessage());
    }
}

