/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.io;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.iterate.mountainduck.fs.FilesystemCallbacks;
import ch.iterate.mountainduck.fs.buffer.MarkerBuffer;
import ch.iterate.mountainduck.io.CloseCallback;
import java.io.Closeable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BufferCloseCallback
implements CloseCallback {
    private static final Logger log = LogManager.getLogger((String)BufferCloseCallback.class.getName());
    private final MarkerBuffer buffer;

    public BufferCloseCallback(MarkerBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void closed(Path file, TransferStatus status, Closeable stream, FilesystemCallbacks.Mode mode) {
        if (!PreferencesFactory.get().getBoolean("fs.buffer.enable")) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Close buffer %s", this.buffer));
            }
            this.buffer.close();
        }
    }
}

