/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.mountainduck.fs.buffer;

import ch.cyberduck.core.AlphanumericRandomStringService;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.io.FileBuffer;
import ch.cyberduck.core.local.TemporaryFileServiceFactory;
import ch.iterate.mountainduck.fs.buffer.MarkerBuffer;
import ch.iterate.mountainduck.io.BufferInputStream;
import ch.iterate.mountainduck.io.BufferOutputStream;
import ch.iterate.mountainduck.io.Marker;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MarkerFileBuffer
extends FileBuffer
implements MarkerBuffer {
    private static final Logger log = LogManager.getLogger((String)MarkerFileBuffer.class.getName());
    private final Local temporary;
    private final Path file;
    private Long limit = Long.MAX_VALUE;
    private final RangeSet<Long> ranges = TreeRangeSet.create();
    private MarkerBuffer.State state = MarkerBuffer.State.closed;

    public MarkerFileBuffer(Path file) {
        this(TemporaryFileServiceFactory.get().create(new AlphanumericRandomStringService().random()), file);
    }

    public MarkerFileBuffer(Local temporary, Path file) {
        super(temporary);
        this.temporary = temporary;
        this.file = file;
    }

    @Override
    public MarkerFileBuffer withLimit(Long threshold) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Increase limit to %d for %s", threshold, this.file));
        }
        this.limit = threshold;
        return this;
    }

    public Local getTemporary() {
        return this.temporary;
    }

    @Override
    public Long getLimit() {
        return this.limit;
    }

    public synchronized int write(byte[] chunk, Long offset) throws IOException {
        if (offset >= this.limit) {
            switch (this.state) {
                case open: {
                    this.close();
                    if (!log.isInfoEnabled()) break;
                    log.info(String.format("Deleted buffer %s for file %s", this, this.file));
                }
            }
            return 0;
        }
        int len = super.write(chunk, offset);
        this.save(offset, len);
        return len;
    }

    protected void save(Long offset, int len) {
        Range range = Range.closed((Comparable)offset, (Comparable)Long.valueOf(offset + (long)len));
        if (log.isDebugEnabled()) {
            log.debug(String.format("Add buffered range %s for file %s", range, this.file));
        }
        this.ranges.add(range);
        this.state = MarkerBuffer.State.open;
    }

    public void truncate(Long length) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Truncate buffer %s to %s for file %s", this, length, this.file));
        }
        super.truncate(length);
        this.state = MarkerBuffer.State.open;
    }

    public synchronized void close() {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Close buffer %s for file %s", this, this.file));
        }
        super.close();
        this.ranges.clear();
        this.state = MarkerBuffer.State.closed;
    }

    @Override
    public boolean contains(Marker marker, Long length) {
        Range range = Range.closed((Comparable)marker.current(), (Comparable)Long.valueOf(marker.current() + length));
        if (this.ranges.encloses(range)) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("No buffered range %s for file %s", range, this.file));
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.ranges.isEmpty();
    }

    @Override
    public boolean isComplete() {
        return this.contains(new Marker(this.file, 0L), this.length());
    }

    @Override
    public MarkerBuffer.State getState() {
        return this.state;
    }

    @Override
    public OutputStream getOutputStream() {
        return new BufferOutputStream(this);
    }

    @Override
    public InputStream getInputStream() {
        return new BufferInputStream(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MarkerFileBuffer{");
        sb.append("file=").append(this.file);
        sb.append(", temporary=").append(this.temporary);
        sb.append(", ranges=").append(this.ranges);
        sb.append(", limit=").append(this.limit);
        sb.append(", state=").append((Object)this.state);
        sb.append('}');
        return sb.toString();
    }
}

